/**
 * Created by sinosoft on 2018/5/18.
 */

layui.use(['form', 'table', 'layer', 'laydate', 'upload'], function () {
    var table = layui.table;
    var form = layui.form;
    var layer = layui.layer;
    var laydate = layui.laydate;
    var upload = layui.upload;

    //表单验证
    form.verify({
        identifyNo: function (value) {
            if (value != null && value != "") {
                //身份证暂时保留原来校验
                //人员工号生成方法在UserMaintService.getRandomUserCode()
                if (!new RegExp("^[1-9]\\d{5}(18|19|([23]\\d))\\d{2}((0[1-9])|(10|11|12))(([0-2][1-9])|10|20|30|31)\\d{3}[0-9Xx]$").test(value)) {
                    return "请输入正确的身份证号";
                }
            }
        },
        mobile: function (value) {
            if (value != null && value != "") {
                if (!new RegExp("^1([358][0-9]|4[579]|66|7[0135678]|9[89])[0-9]{8}$").test(value)) {
                    return "请输入正确的联系方式";
                }
            }
        }
    });

    //监听条件查询提交
    form.on('submit(queryDemo)', function () {
        try {
            //禁用搜索按钮
            $("#queryBtn").attr("disabled", "disabled");
            $("#queryBtn").addClass("layui-btn-disabled");
            $("#queryBtn").html("<i class=\"layui-icon\">&#xe615;</i>搜索中");

            table.reload('dataTable', {
                loading: true,
                url: myctx + '/antiFraud/query',
                contentType: 'application/json',
                method: 'post',
                where: $('#queryForm').serializeObject(),
                page: {
                    curr: 1  //重新从第 1 页开始
                },
                done: function () {
                    $("#queryBtn").html("<i class=\"layui-icon\">&#xe615;</i>搜 索");
                    $("#queryBtn").removeAttr("disabled");
                    $("#queryBtn").removeClass("layui-btn-disabled");
                }
            });
        } catch (err) {
        }
        return false;
    });

    //监听条件下载提交
    form.on('submit(downloadA)', function () {
        try {
            //禁用条件搜索按钮
            $("#downloadABtn").attr("disabled", "disabled");
            $("#downloadABtn").addClass("layui-btn-disabled");
            $("#downloadABtn").html("<i class=\"layui-icon\">&#xe601;</i>正在提数");

            // 创建一个a标签用于下载
            var a = document.createElement('a');
            a.download = 'data.xlsx';
            a.href = myctx + '/antiFraud/downloadA?' + $('#queryForm').serialize();
            $("body").append(a);  // 修复firefox中无法触发click
            a.click();
            $(a).remove();

            $("#downloadABtn").html("<i class=\"layui-icon\">&#xe601;</i>条件下载");
            $("#downloadABtn").removeAttr("disabled");
            $("#downloadABtn").removeClass("layui-btn-disabled");

        } catch (err) {
        }
        return false;
    });

    form.on('submit(downloadB)', function () {
        try {
            //禁用条件搜索按钮
            $("#downloadBBtn").attr("disabled", "disabled");
            $("#downloadBBtn").addClass("layui-btn-disabled");
            $("#downloadBBtn").html("<i class=\"layui-icon\">&#xe601;</i>正在提数");

            $.ajax({
                url: myctx + '/antiFraud/downloadB',
                contentType: 'application/json',
                // type: 'post',
                data: $('#queryForm').serializeObject(),
                // data: $('#queryForm').serializeObject(),
                success: function (e) {
                    var res = JSON.parse(e);
                    if(res.code == 0){
                        //创建一个a标签用于下载
                        var a = document.createElement('a');
                        a.download = 'data.xlsx';
                        a.href = myctx + '/antiFraud' + JSON.parse(e).url;
                        $("body").append(a);  // 修复firefox中无法触发click
                        a.click();
                        $(a).remove();
                    } else {
                        layer.msg(JSON.parse(e).message);
                    }
                    $("#downloadBBtn").html("<i class=\"layui-icon\">&#xe601;</i>条件下载");
                    $("#downloadBBtn").removeAttr("disabled");
                    $("#downloadBBtn").removeClass("layui-btn-disabled");
                }
            });

        } catch (err) {
        }
        return false;
    });

    //DataTable设置
    table.render({
        id: 'dataTable',
        elem: '#dataTable',
        url: myctx + '/antiFraud/query',  //查询数据调用的接口
        method: 'post',
        where: {
            identifyNo: $("#identifyNo").val(),
            mobile: $("#mobile").val(),
            updateDateStart: $("#updateDateStart").val(),
            updateDateEnd: $("#updateDateEnd").val(),
            isInit: "0"
        },
        skin: 'line',    //行边框
        even: true,      //开启隔行背景
        loading: true,   //请求数据时显示loading
        page: {
            curr: 1,     //默认显示页
            limit: 90,   //每页显示的数据条数。根据count和limit计算laypage页数
//                limits: ['10', '20', '30', '50'],
            groups: 5,  //连续出现的页码个数
            prev: '上一页',
            next: '下一页',
            first: '首页',
            last: '末页',
            layout: ['prev', 'page', 'next', 'limit', 'skip', 'count']  //自定义分页布局
        },
        cols: [[         //设置表头
            {type: 'numbers', title: '序号', width: '5%'},
            {field: 'identifyNumber', title: '身份证号', width: '15%', sort: true},
            {field: 'phoneNumber', title: '联系方式', width: '15%', sort: true},
            {field: 'riskScore', title: '风险分', width: '10%', sort: true},
            {field: 'riskMessage', title: '风险信息', width: '15%'},
            {field: 'comCode', title: '归属机构', width: '10%'},
            {field: 'createDate', title: '获取时间', width: '20%', templet: '#createTime', sort: true},
            {field: 'operate', title: '操作', width: '10%', toolbar: '#modBtn'}
        ]]
    });

    $('#upload').click(function () {
        var layerIndex = layer.open({
            type: 1,
            title: '上传操作',
            closeBtn: 1,
            area: ['380px', '250px'],
            shadeClose: true,
            scrollbar: false,
            move: false,
            content:'<div id="uploadLayer">\n' +
            '<button class="layui-btn layui-btn-normal layui-btn-fluid layui-anim layui-anim-upbit" id="uploadForQuery" > <i class="layui-icon">&#xe681;</i>上传查询 </button> \n' +
            '<button class="layui-btn layui-btn-normal layui-btn-fluid layui-anim layui-anim-upbit" id="uploadForDownload" > <i class="layui-icon">&#xe601;</i>查询下载 </button> \n' +
            '<button class="layui-btn layui-btn-normal layui-btn-fluid layui-anim layui-anim-upbit" id="modelDownload" > <i class="layui-icon">&#xe663;</i>模板下载 </button></div> \n' +
            '<div id="uploadTip"><b style="font-size: 17px; color: rgba(35, 33, 35, 0.65);">上传查询：</b><br>&emsp;上传数据文档，根据文档数据进行查询展示。</div>'
        });

        $('#uploadForQuery').mouseover(function (){
            $("#uploadTip").empty().append('<b style="font-size: 17px; color: rgba(35, 33, 35, 0.65);">上传查询：</b><br/>&emsp;上传数据文档，根据文档数据进行查询展示。');
        });

        $('#uploadForDownload').mouseover(function (){
            $("#uploadTip").empty().append('<b style="font-size: 17px; color: rgba(35, 33, 35, 0.65);">查询下载：</b><br/>&emsp;上传数据文档，根据文档数据生成风险分信息EXCEL文档并下载。');
        });

        $('#modelDownload').click(function () {
            // 创建一个a标签用于下载
            var a = document.createElement('a');
            a.download = 'model.xlsx';
            a.href = myctx + '/download/model.xlsx';
            $("body").append(a);  // 修复firefox中无法触发click
            a.click();
            $(a).remove();
        }).mouseover(function (){
            $("#uploadTip").empty().append('<b style="font-size: 17px; color: rgba(35, 33, 35, 0.65);">模板下载：</b><br/>&emsp;下载用于当前窗口上传功能所用到的上传文件的模板。');
        });

        upload.render({
            elem: '#uploadForQuery',
            url: myctx + '/antiFraud/upload', //上传接口
            accept: 'file',
            before: function (obj) {
                layer.load();
            },
            done: function (res) {
                //上传完毕回调
                if(res.code == 0){
                    layui.table.reload('dataTable', {
                        url: "",
                        data: res.data,
                        page: {
                            curr: 1,
                            count: res.count
                        }
                    });
                }else{
                    layer.alert(res.message, {
                        icon: 2
                    });
                }
                layer.closeAll('loading');
                layer.close(layerIndex);
            },
            error: function () {
                //请求异常回调
                layer.alert("连接服务器异常", {
                    icon: 2
                });
                layer.closeAll('loading');
                layer.close(layerIndex);
            }
        });

        upload.render({
            elem: '#uploadForDownload',
            url: myctx + '/antiFraud/uploadA', //上传接口
            accept: 'file',
            before: function (obj) {
                layer.load();
            },
            done: function (res) {
                //上传完毕回调
                if(res.code == 0){
                    //创建一个a标签用于下载
                    var a = document.createElement('a');
                    a.download = 'data.xlsx';
                    a.href = myctx + '/antiFraud' + res.url;
                    $("body").append(a);  // 修复firefox中无法触发click
                    a.click();
                    $(a).remove();
                }else{
                    layer.alert(res.message, {
                        icon: 2
                    });
                }
                layer.closeAll('loading');
                layer.close(layerIndex);
            },
            error: function () {
                //请求异常回调
                layer.alert("连接服务器异常", {
                    icon: 2
                });
                layer.closeAll('loading');
                layer.close(layerIndex);
            }
        });
    });

    /*var uploadInst = upload.render({
        elem: '#upload', //绑定元素
        url: myctx + '/antiFraud/upload', //上传接口
        accept: 'file',
        before: function (obj) {
            layer.load();
        },
        done: function (res) {
            //上传完毕回调
            if(res.code == 0){
                layui.table.reload('dataTable', {
                    url: "",
                    data: res.data,
                    page: {
                        curr: 1,
                        count: res.count
                    }
                });
            }else{
                layer.alert(res.message, {
                    icon: 2
                });
            }
            layer.closeAll('loading');
        },
        error: function () {
            //请求异常回调
            layer.alert("连接服务器异常", {
                icon: 2
            });
            layer.closeAll('loading');
        }
    });*/

    //获取初始化DataTable数据
    // var initData;
    // $.ajax({
    //     url: myctx + '/antiFraud/query',
    //     contentType: 'application/json',
    //     method: 'post',
    //     where: {
    //         identifyNo: $("#identifyNo").val(),
    //         mobile: $("#mobile").val(),
    //         updateDateStart: $("#updateDateStart").val(),
    //         updateDateEnd: $("#updateDateEnd").val(),
    //         isInit: "0"
    //     },
    //     success: function (e) {
    //         initData = e;
    //         table.reload('dataTable', {
    //             data: initData.data,
    //             page: {
    //                 curr: 1,  //重新从第 1 页开始
    //                 count: initData.count
    //             },
    //         });
    //     }
    // });


    //监听工具
    table.on('tool(contentTable)', function (obj) {
        //tool是工具条事件名，contentTable是table原始容器的属性 lay-filter="对应的值"
        //window.location.href = '${ctx}/userMaint/edit?id=' + obj.data.id;  //当前行的数据的id
        alert("暂未开放，敬请期待！");
    });

    laydate.render({
        elem: '#updateDateStart', //或 elem: document.getElementById('test')、elem: lay('#test') 等
        type: 'datetime',
        formate: 'yyyy-MM-dd HH:mm:ss'
    });

    laydate.render({
        elem: '#updateDateEnd', //或 elem: document.getElementById('test')、elem: lay('#test') 等
        type: 'datetime',
        formate: 'yyyy-MM-dd HH:mm:ss'
    });

});

//完成页面加载后，初始化标志位置为非初始化
$("#isInit").val("1");

$(".query-form .layui-form-item input[type='text']").on("change", function () {
    $("#queryBtn").html("<i class=\"layui-icon\">&#xe615;</i>搜 索");
    $("#queryBtn").removeAttr("disabled");
    $("#queryBtn").removeClass("layui-btn-disabled");
    // $("#downloadABtn").html("<i class=\"layui-icon\">&#xe601;</i>条件下载");
    // $("#downloadABtn").removeAttr("disabled");
    // $("#downloadABtn").removeClass("layui-btn-disabled");
    $("#downloadBBtn").html("<i class=\"layui-icon\">&#xe601;</i>条件下载");
    $("#downloadBBtn").removeAttr("disabled");
    $("#downloadBBtn").removeClass("layui-btn-disabled");
});

$(".query-form .layui-form-item button[type='reset']").on("click", function () {
    $("#queryBtn").html("<i class=\"layui-icon\">&#xe615;</i>搜 索");
    $("#queryBtn").removeAttr("disabled");
    $("#queryBtn").removeClass("layui-btn-disabled");
    // $("#downloadABtn").html("<i class=\"layui-icon\">&#xe601;</i>条件下载");
    // $("#downloadABtn").removeAttr("disabled");
    // $("#downloadABtn").removeClass("layui-btn-disabled");
    $("#downloadBBtn").html("<i class=\"layui-icon\">&#xe601;</i>条件下载");
    $("#downloadBBtn").removeAttr("disabled");
    $("#downloadBBtn").removeClass("layui-btn-disabled");
});


//对Date的扩展，将 Date 转化为指定格式的String
//月(M)、日(d)、小时(h)、分(m)、秒(s)、季度(q) 可以用 1-2 个占位符，
//年(y)可以用 1-4 个占位符，毫秒(S)只能用 1 个占位符(是 1-3 位的数字)
//例子：
//(new Date()).Format("yyyy-MM-dd hh:mm:ss.S") ==> 2006-07-02 08:09:04.423
//(new Date()).Format("yyyy-M-d h:m:s.S")      ==> 2006-7-2 8:9:4.18
Date.prototype.Format = function (fmt) { //author: meizz
    var o = {
        "M+": this.getMonth() + 1,                 //月份
        "d+": this.getDate(),                    //日
        "h+": this.getHours(),                   //小时
        "m+": this.getMinutes(),                 //分
        "s+": this.getSeconds(),                 //秒
        "q+": Math.floor((this.getMonth() + 3) / 3), //季度
        "S": this.getMilliseconds()             //毫秒
    };
    if (/(y+)/.test(fmt))
        fmt = fmt.replace(RegExp.$1, (this.getFullYear() + "").substr(4 - RegExp.$1.length));
    for (var k in o)
        if (new RegExp("(" + k + ")").test(fmt))
            fmt = fmt.replace(RegExp.$1, (RegExp.$1.length == 1) ? (o[k]) : (("00" + o[k]).substr(("" + o[k]).length)));

    return fmt;
}