/**
 * 业务员投保流程公共JS
 * @author Akers.Liang akersliang@foxmail.com
 */
// 如果所选的证件类型为公司，则投、被保险人的生日都不需选择，并为"-"
$('#applicantIdType').on('change', function () {

});


function checkApplicantInfoAndInsuranInfo() {

    var insuredIdentity = $('#insuredIdentity').val();
    var name = $("#name").val();
    var idType = $("#idType").val();
    var idNumber = $("#idNumber").val();
    var applicantName = $("#applicantName").val();
    var applicantIdType = $("#applicantIdType").val();
    var applicantIdNumber = $("#applicantIdNumber").val();
    if (insuredIdentity == '0') {
        return true;
    } else {
        if (name == applicantName) {
            showAlert('投保人和被保人姓名不能相同');
            return false;
        }
        if (idType == applicantIdType) {
            if (idNumber == applicantIdNumber) {
                showAlert('投保人和被保人证件号码不能相同');
                return false;
            } else {
                return true;
            }
        } else {
            return true;
        }
    }
}


function showAlert(title) {
    $('.popup-title').html(title);
    $('.mask,.popup').show();
}
$('.popup-button').click(function () {
    $('.mask,.popup').hide();
});
function showLoading(title) {
    $('.load-mask').show();
    $('.load-popup').show();
    $('.load-content').html(title);
}
function hideLoading() {
    $('.load-mask').hide();
    $('.load-popup').hide();
}

function validateName(element) {
    var $this = $(element);
    var value = $this.val();
    if (isNotNull(value)) {
        var result = checkName(value);
        if (!result.flag) {
            $this.parent('.borderbot').addClass('error');
            return false;
        } else {
            $this.parent('.borderbot').removeClass('error');
            return true;
        }
    }
    else {
        $this.parent('.borderbot').addClass('error');
        return false;
    }
}

function validateIdCard(element, type) {
    var $this = $(element);
    var value = $this.val();
    if (isNotNull(value)) {
        var idType;
        if (type == '1') {
            idType = $('#idType').val();
        } else {
            idType = $('#applicantIdType').val();
        }
        if (idType == '01') {
            var result = checkIdentityNum(value);
            if (!result.flag) {
                $this.parent('.borderbot').addClass('error');
                return false;
            } else {
                $this.parent('.borderbot').removeClass('error');
                return true;
            }
        } else if (idType == '31') {
            if(checkCodingForTheRepresentationOfOrganization(value)) {
                $this.parent('.borderbot').removeClass('error');
                return true;
            } else {
                $this.parent('.borderbot').addClass('error');
                return false;
            }
        } else {
            if (validateCard(value)) {
                $this.parent('.borderbot').removeClass('error');
                return true;
            } else {
                $this.parent('.borderbot').addClass('error');
                return false;
            }
        }
    } else {
        $this.parent('.borderbot').addClass('error');
        return false;
    }
}

function validateMobile(element) {
    var $this = $(element);
    var value = $this.val();
    if (isNotNull(value)) {
        var result = checkMobile(value);
        if (!result.flag) {
            $this.parent('.borderbot').addClass('error');
            return false;
        } else {
            $this.parent('.borderbot').removeClass('error');
            return true;
        }
    } else {
        $this.parent('.borderbot').addClass('error');
        return false;
    }
}

function validateEmail(element) {
    var $this = $(element);
    var value = $this.val();
    if (isNotNull(value)) {
        var result = checkEmail(value);
        if (!result.flag) {
            $this.parent('.borderbot').addClass('error');
            return false;
        } else {
            $this.parent('.borderbot').removeClass('error');
            return true;
        }
    }
        else {
        // $this.parent('.borderbot').addClass('error');
        return true;
    }
}

function validateNull(element) {
    var $this = $(element);
    var value = $this.val();
    if (isNotNull(value)) {
        $this.parent('.borderbot').removeClass('error');
        return true;
    } else {
        $this.parent('.borderbot').addClass('error');
        return false;
    }
}

/**
 * 校验邮编
 * @param element
 * @returns {boolean}
 */
function validatePostCode(element) {
    var $this = $(element);
    var value = $this.val();
    if (isNotNull(value)) {
        var result = checkPostCode(value);
        if (!result) {
            $this.parent('.info').addClass('error');
            return false;
        } else {
            $this.parent('.info').removeClass('error');
            return true;
        }
    } else {
        $this.parent('.info').addClass('error');
        return false;
    }
}

/**
 * 获取通用的数据对象
 */
function basicDatas() {
    var data = {};
    data.policyPay = '1';
    data.age = 0;
    data.applicantAge = 0;
    data.beneficiaryBirthDay = '';
    data.beneficiaryGender = 0;
    data.name = $("#name").val();
    data.idType = $("#idType").val();
    data.idNumber = $("#idNumber").val();
    data.mobile = $("#mobile").val();
    data.email = $("#email").val();
    data.gender = $("#gender").val();
    data.birthDay = $("#birthDay").val();
    data.applicantName = $("#applicantName").val();
    data.applicantIdType = $("#applicantIdType").val();
    data.applicantIdNumber = $("#applicantIdNumber").val();
    data.applicantGender = $("#applicantGender").val();
    data.applicantInfoBirthDay = $("#applicantInfoBirthDay").val();
    data.applicantMobile = $("#applicantMobile").val();
    data.inCityInfo = $('#inCityInfo').val();
    data.province = $("#province").val();
    data.city = $("#city").val();
    data.area = $("#area").val();
    data.address = $("#address").val();
    data.insuredIdentity = $("#insuredIdentity").val();
    data.applicantIsSocialSe = $("#applicantIsSocialSe").val();
    data.recommendId = $("#recommendId").val();
    data.insuranceStartDate = $("#insuranceStartDate").val();
    data.insuranceEndDate = $("#insuranceEndDate").val();
    data.productItemCode = $("#productItemCode").val();
    data.isBeneficiary = $('#isBeneficiary').val();
    data.beneficiaryName = $('#beneficiaryName').val();
    data.beneficiaryIdNumber = $('#beneficiaryIdNumber').val();
    data.oldPolicyNo =$('#last-policy').val();
    if (data.idType == '01') {
        data.age = getAgeBybirthDay(getbirthDayByIdNum(data.idNumber));
        data.birthDay = getbirthDayByIdNum(data.idNumber);
        data.gender = getSexByIdNum(data.idNumber);
    } else {
        data.birthDay = $('#birthDay').val();
        data.age = getAgeBybirthDay(data.birthDay);
    }
    if (data.applicantIdType == '01') {
        data.applicantAge = getAgeBybirthDay(getbirthDayByIdNum(data.applicantIdNumber));
        data.applicantInfoBirthDay = getbirthDayByIdNum(data.applicantIdNumber);
        data.applicantGender = getSexByIdNum(data.applicantIdNumber);
    } else {
        var applicantInfoBirthDay = $('#applicantInfoBirthDay').val();
        data.applicantAge = getAgeBybirthDay(data.applicantInfoBirthDay);
    }
    if (data.isBeneficiary == '1') {
        data.beneficiaryBirthDay = getbirthDayByIdNum(data.beneficiaryIdNumber);
        data.beneficiaryGender = getSexByIdNum(data.beneficiaryIdNumber);
    }
    if (data.insuredIdentity == '0') {//如果是本人,人人安康做被保人赋值给投保人的处理
        data.applicantName = data.name;
        data.applicantIdType = data.idType;
        data.applicantIdNumber = data.idNumber;
        data.applicantGender = data.gender;
        data.applicantAge = data.age;
        data.applicantInfoBirthDay = data.birthDay;
        data.applicantMobile = data.mobile;
        $("#applicantName").val(data.name);
        $("#applicantIdType").val(data.idType);
        $("#applicantIdNumber").val(data.idNumber);
        $("#applicantGender").val(data.gender);
        $("#applicantAge").val(data.age);
        $("#applicantInfoBirthDay").val(data.birthDay);
        $("#applicantMobile").val(data.mobile);

    }

    return data;
}

/**
 * 通用输入检查
 */
function checkInputs(options) {
    options = $.extend({
        success: function () {

        },
        error: function (errorCount, errorNames, messages) {

        }
    }, options);
    var data = basicDatas();
    var errorNames = [];
    var messages = [];
    var errorCount = 0;
    if (!validateName("#name")) {
        errorCount++;
        errorNames.push("name");
        messages.push('填写的*被保人姓名有误，请重新修改信息。');
    }
    if (!validateIdCard("#idNumber", '1')) {
        errorCount++;
        errorNames.push("idNumber");
        messages.push('填写的*被保人证件号码有误，请重新修改信息。');
    }
    if (!validateMobile("#mobile")) {
        errorCount++;
        errorNames.push("mobile");
        messages.push('填写的*被保人手机号有误，请重新修改信息。');
    }
    if (!validateName("#applicantName")) {
        errorCount++;
        errorNames.push("applicantName");
        messages.push('填写的*投保人姓名有误，请重新修改信息。');
    }
    if (!validateIdCard("#applicantIdNumber", '2')) {
        errorCount++;
        errorNames.push("applicantIdNumber");
        messages.push('填写的*投保人证件号码有误，请重新修改信息。');
    }

    if (data.applicantAge < 18) {
        errorCount++;
        errorNames.push("applicantAge");
        messages.push('投保人未满18周岁，请重新修改信息。');
    }
    if (!validateMobile("#applicantMobile")) {
        errorNames.push("applicantMobile");
        errorCount++;
        messages.push('填写的*投保人手机号有误，请重新修改信息。');
    }
   /* if(!validateNull('#inCityInfo')) {
        errorNames.push("inCityInfo");
        errorCount++;
        messages.push('请选择被保人常住城市。');
    }*/
    if (data.insuredIdentity != '0') {
        if (data.name == data.applicantName) {
            errorCount++;
            errorNames.push("applicantName");
            messages.push('投保人和被保人姓名不能相同');
        }
        if (data.idType == data.applicantIdType && data.idNumber == data.applicantIdNumber) {
            errorCount++;
            errorNames.push("applicantName");
            messages.push('投保人和被保人证件号码不能相同');
        }
    }
  /*  if (!isNotNull(data.address)) {
        errorCount++;
        errorNames.push("address");
        messages.push('填写的*投保人地址不能为空');
    }*/
   /* if (!validatePostCode('#area')) {
        errorCount++;
        errorNames.push("postCode");
        messages.push('填写的*投保人邮编有误，请正确填写被保人常住地址的邮政编码');
    }*/

    if (data.isBeneficiary == '1') {
        if (!validateName("#beneficiaryName")) {
            errorCount++;
            errorNames.push("beneficiaryName");
            messages.push('填写的*受益人姓名有误，请重新修改信息。');
        }
        if (!validateIdCard("#beneficiaryIdNumber", '3')) {
            errorCount++;
            errorNames.push("beneficiaryIdNumber");
            messages.push('填写的*受益人证件号码有误，请重新修改信息。');
        }
    }
    if (!validateStartDate(data.insuranceStartDate)) {
        errorCount++;
        errorNames.push("insuranceStartDate");
        messages.push('起保日期不能小于当前日期，日期已修改为T+1。');
        setInsuranDate(getDateByDateParams(new Date(), '', '', '', '', '1', '+'));
    }

    if(errorCount > 0) {
        options.error.call(this, errorCount, errorNames, messages);
    } else {
        options.success.call(this);
    }
}