/**
 * Created by Akers
 */

// 提交校验
function doValid() {
    var errorCount = 0;

    // if (!validateIdNum("#idNum")) {
    //     errorCount++;
    //     // showAlert('填写的身份证后四位格式有误，请重新修改。');
    // }

    var dataObj = {
        idNum: $("#idNum").val(),
        recommendId: $("#recommendId").val()
    };
    if (errorCount == 0) {
        var url = '/sfzn/reinsurance/idverify.do?recommendId='+$("#recommendId").val();
        showLoading();
        ajaxRequest(url, dataObj, function successCallback(data) {
            if (data.respCode == '0000') {
                if(data.passed) {
                    hideLoading();
                    window.location.href = data.callBack;
                } else {
                    hideLoading();
                    showAlert('身份认证失败！请正确输入您身份证的后四位');
                }
            } else {
                hideLoading();
                if(isNotNull(data.respMsg)) {
                    showAlert(data.respMsg);
                }else {
                    showAlert('网络错误，请稍后重试！');
                }
            }
        },function errorCallback(error) {
            hideLoading();
            showAlert('网络错误，请稍后重试！');
        });
    }

}

function showAlert(title) {
    $('.popup-title').html(title);
    $('.mask,.popup').show();
}
$('.popup-button').click(function () {
    $('.mask,.popup').hide();
});
function showLoading(title) {
    $('.load-mask').show();
    $('.load-popup').show();
    $('.load-content').html(title);
}
function hideLoading() {
    $('.load-mask').hide();
    $('.load-popup').hide();
}

function ajaxRequest(url, data, successCallback, errorCallback) {
    $.ajax({
        url: url,
        data: JSON.stringify(data),
        type: "post",
        dataType: "json",
        contentType: "application/json",
        cache: false,
        success: function (data) {
            data = JSON.parse(data);
            if (typeof successCallback == 'function') {
                successCallback(data);
            }
        },
        error: function (error) {
            if (typeof errorCallback == 'function') {
                errorCallback(error);
            }
        }
    });
}

// 身份证号末4位正则
var _regxIdnumLast4 = /\d{3}[\dXx]{1}/;

/**
 * idNum改变时候的校验
 * @param element
 */
function idNumChangeValidate(element) {
    var $this = $(element);
    $this.val($this.val().toUpperCase());
    var value = $this.val();
    if (isNotNull(value)) {
        $this.parent('.borderbot').removeClass('error');
        if(value.length >= 4) {
            // 正则匹配，数字及X
            if(!_regxIdnumLast4.test($this.val())) {
                $this.parent('.borderbot').addClass('error');
            }
        }
    } else {
        $this.parent('.borderbot').addClass('error');
    }
}

function validateIdNum(element) {
    var $this = $(element);
    $this.val($this.val().toUpperCase());
    var value = $this.val();
    if (isNotNull(value)) {
        $this.parent('.borderbot').removeClass('error');
        if(value.length < 4) {
            showAlert("您输入的身份证号不合法，请正确输入您的身份证后四位");
            $this.parent('.borderbot').addClass('error');
            return false
        }

        // 正则匹配，数字及X
        if(_regxIdnumLast4.test($this.val())) {
            return true
        } else {
            showAlert("您输入的身份证号不合法，请正确输入您的身份证后四位");
            $this.parent('.borderbot').addClass('error');
            return false
        }
    } else {
        showAlert("请输入您的身份证后四位");
        $this.parent('.borderbot').addClass('error');
        return false;
    }
}