function isArray(arr) {
    return (Array.isArray ? Array.isArray(arr) : (typeof arr === 'object') && (arr instanceof Array));
}



function validateIdCard(element, type) {
    var $this = $(element);
    var value = $this.val();
    if (isNotNull(value)) {
        var idType;
        if (type == '1') {
            idType = $('#idType').val();
        } else {
            idType = $('#applicantIdType').val();
        }
        if (idType == '01') {
            var result = checkIdentityNum(value);
            if (!result.flag) {
                $this.parent('.borderbot').addClass('error');
                return false;
            } else {
                $this.parent('.borderbot').removeClass('error');
                getProductItem();
                return true;
            }
        } else if (idType == '31') {
            if(checkCodingForTheRepresentationOfOrganization(value)) {
                $this.parent('.borderbot').removeClass('error');
                return true;
            } else {
                $this.parent('.borderbot').addClass('error');
                return false;
            }
        } else if(idType=='37')
        {
            if (validateCard(value)) {
                var applicantIdNumber = $("#applicantIdNumber").val();
                var url = '/sfzn/renewal/insurePayInfo.do?applicantIdNumber=' + applicantIdNumber;
                ajaxRequest(url, dataObj, function successCallback(data) {
                    hideLoading();
                    if (data.respCode == '0000') {
                        $("#applicantIdNumber").val(data.organizationCode);
                        $this.parent('.borderbot').removeClass('error');
                        return true;
                    } else {
                        $this.parent('.borderbot').addClass('error');
                        return false;
                    }
                }, function errorCallback(error) {
                    $this.parent('.borderbot').addClass('error');
                    return false;
                });

            } else {
                $this.parent('.borderbot').addClass('error');
                return false;
            }

        }
        else {
            if (validateCard(value)) {
                $this.parent('.borderbot').removeClass('error');
                return true;
            } else {
                $this.parent('.borderbot').addClass('error');
                return false;
            }
        }
    } else {
        $this.parent('.borderbot').addClass('error');
        return false;
    }
}

function validateOrganizeCode(element, type, flag) {
    return true;
    var $this = $(element);
    var value = $this.val();
    if (isNotNull(value)) {
        var $infoEl = $this.parent('.borderbot');
        if (checkCodingForTheRepresentationOfOrganization(value)) {
            $infoEl.html($infoEl.attr("txt_backup"));
            $infoEl.removeClass('error');
            return true;
        } else {
            $infoEl.addClass('error');
            layui.use('layer', function () {
                layer.alert('请输入正确的组织结构代码证号, 例如客户"英德市石灰铺镇人民政府"，统一社会信用代码是"11441881007312939J"，组织机构代码是"00731293-9"')
            });
            return false;
        }
    }
    else {
        $this.parent('.borderbot').addClass('error');
        return false;
    }
}

function ajaxRequest(url, data, successCallback, errorCallback) {
    $.ajax({
        url: url,
        data: JSON.stringify(data),
        type: "post",
        dataType: "json",
        contentType: "application/json",
        cache: false,
        success: function (data) {
            data = JSON.parse(data);
            if (typeof successCallback == 'function') {
                successCallback(data);
            }
        },
        error: function (error) {
            if (typeof errorCallback == 'function') {
                errorCallback(error);
            }
        }
    });
}


function showAlert(title) {
    $('.popup-title').html(title);
    $('.mask,.popup').show();
}
$('.popup-button').click(function () {
    $('.mask,.popup').hide();
});
function showLoading(title) {
    $('.load-mask').show();
    $('.load-popup').show();
    $('.load-content').html(title);
}
function hideLoading() {
    $('.load-mask').hide();
    $('.load-popup').hide();
}


function checkApplicantInfoAndInsuranInfo() {

    var insuredIdentity = $('#insuredIdentity').val();
    var name = $("#name").val();
    var idType = $("#idType").val();
    var idNumber = $("#idNumber").val();
    var applicantName = $("#applicantName").val();
    var applicantIdType = $("#applicantIdType").val();
    var applicantIdNumber = $("#applicantIdNumber").val();
    if (insuredIdentity == '0') {
        return true;
    } else {
        if (name == applicantName) {
            showAlert('投保人和被保人姓名不能相同');
            return false;
        }
        if (idType == applicantIdType) {
            if (idNumber == applicantIdNumber) {
                showAlert('投保人和被保人证件号码不能相同');
                return false;
            } else {
                return true;
            }
        } else {
            return true;
        }
    }
}

function initInsuranInfo() {
    var idType = $("#idType").val();
    if (idType == '01') {
        $('.card').val(idType);
        $('#idType').val(idType);
        $('.cardhide').hide();
    } else {
        $('.card').val(idType);
        $('#idType').val(idType);
        $('.cardhide').show();
    }
    var gender = $("#gender").val();
    if (gender == '1') {
        $('.singlenan').addClass('show');
        $('.singlenv').removeClass("show");
    } else if (gender == '2') {
        $('.singlenv').addClass('show');
        $('.singlenan').removeClass("show");
    }
    var insuredIdentity = $("#insuredIdentity").val();
    $('.relationship').each(function () {
        var dataValue = $(this).attr('data-value');
        if (dataValue == insuredIdentity) {
            $('.relationship').removeClass("show");
            $(this).addClass('show');
            $('#insuredIdentity').val(dataValue);
        }
    });
    $('.relationship1').each(function () {
        var dataValue = $(this).attr('data-value');
        if (dataValue == insuredIdentity) {
            $('.relationship1').removeClass("show");
            $(this).addClass('show');
            $('#insuredIdentity').val(dataValue);
        }
    });
    if (insuredIdentity == '0') {//如果是本人
        $('.applicantInfo').hide();
    } else {
        $('.applicantInfo').show();
    }
    var applicantIsSocialSe = $("#applicantIsSocialSe").val();
    if (applicantIsSocialSe == '1') {
        $('.single2').addClass('show');
        $('.single1').removeClass("show");
    } else {
        $('.single2').removeClass('show');
        $('.single1').addClass("show");
    }
    var a = $("#birthDay").val();
    var birthDay = getDateByDateParams($("#birthDay").val(), '', '', '', '', '', '');
    $('#insuredBirthDay').html(birthDay);
    var insuranceStartDate = getDateByDateParams($("#insuranceStartDate").val(), '', '', '', '', '', '');
    var startDate = insuranceStartDate;
    if (insuranceStartDate == null || insuranceStartDate == "") {
        startDate = getDateByDateParams(new Date(), "", "", "", "", "1", "+");
    }
    setInsuranDate(startDate);
    // getProductItem();

    var isBeneficiary = $("#isBeneficiary").val();
    if (isBeneficiary == '1') {
        $('.select-people').find('div').removeClass('peopleImg');
        $('.select-people').find('div').addClass('dis-peopleImg');
        $('.wrap.beneficiaryWrap').show();
    } else {
        $('.select-people').find('div').removeClass('dis-peopleImg');
        $('.select-people').find('div').addClass('peopleImg');
        $('.wrap.beneficiaryWrap').hide();
    }
}

function savePayInfo(toUrl) {
    var age = 0;
    var applicantAge = 0;
    var name = $("#name").val();
    var idType = $("#idType").val();
    var idNumber = $("#idNumber").val();
    var mobile = $("#mobile").val();
    var email = $("#email").val();
    var gender = $("#gender").val();
    var birthDay = $("#birthDay").val();
    var applicantName = $("#applicantName").val();
    var applicantIdType = $("#applicantIdType").val();
    var applicantIdNumber = $("#applicantIdNumber").val();
    var applicantGender = $("#applicantGender").val();
    var applicantInfoBirthDay = $("#applicantInfoBirthDay").val();
    var applicantMobile = $("#applicantMobile").val();
    var inCityInfo = $('#inCityInfo').val();
    var province = $("#province").val();
    var city = $("#city").val();
    var area = $("#area").val();
    var address = $("#address").val();
    var insuredIdentity = $("#insuredIdentity").val();
    var applicantIsSocialSe = $("#applicantIsSocialSe").val();
    var recommendId = $("#recommendId").val();
    var insuranceStartDate = $("#insuranceStartDate").val();
    var insuranceEndDate = $("#insuranceEndDate").val();
    var productItemCode = $("#productItemCode").val();
    if (idType == '01') {
        age = getAgeBybirthDay(getbirthDayByIdNum(idNumber));
        birthDay = getbirthDayByIdNum(idNumber);
        gender = getSexByIdNum(idNumber);
    } else {
        birthDay = $('#birthDay').val();
        age = getAgeBybirthDay(birthDay);
    }
    if (applicantIdType == '01') {
        applicantAge = getAgeBybirthDay(getbirthDayByIdNum(applicantIdNumber));
        applicantInfoBirthDay = getbirthDayByIdNum(applicantIdNumber)
        applicantGender = getSexByIdNum(applicantIdNumber);
    } else {
        var applicantInfoBirthDay = $('#applicantInfoBirthDay').val();
        applicantAge = getAgeBybirthDay(applicantInfoBirthDay);
    }
    var dataObj = {
        recommendId: recommendId,
        applicantIsSocialSe: applicantIsSocialSe,
        age: age,
        insuredIdentity: insuredIdentity,
        name: name,
        idType: idType,
        idNumber: idNumber,
        mobile: mobile,
        email: email,
        gender: gender,
        birthDay: birthDay,
        applicantName: applicantName,
        applicantIdType: applicantIdType,
        applicantIdNumber: applicantIdNumber,
        applicantGender: applicantGender,
        applicantAge: applicantAge,
        applicantInfoBirthDay: applicantInfoBirthDay,
        applicantMobile: applicantMobile,
        inCityInfo: inCityInfo,
        province: province,
        city: city,
        area: area,
        address: address,
        insuranceStartDate: insuranceStartDate,
        insuranceEndDate: insuranceEndDate,
        productItemCode: productItemCode
    }
    var url = '/sfzn/reinsurance/insurePayInfo.do?recommendId=' + $("#recommendId").val();
    ajaxRequest(url, dataObj, function successCallback(data) {
        if (data.respCode == '0000') {
            window.location.href = toUrl;
        }
    });
}

function validateName(element) {
    var $this = $(element);
    var value = $this.val();
    if (isNotNull(value)) {
        var result = checkName(value);
        if (!result.flag) {
            $this.parent('.borderbot').addClass('error');
            return false;
        } else {
            $this.parent('.borderbot').removeClass('error');
            return true;
        }
    } else {
        $this.parent('.borderbot').addClass('error');
        return false;
    }
}



function validateMobile(element) {
    var $this = $(element);
    var value = $this.val();
    if (isNotNull(value)) {
        var result = checkMobile(value);
        if (!result.flag) {
            $this.parent('.borderbot').addClass('error');
            return false;
        } else {
            $this.parent('.borderbot').removeClass('error');
            return true;
        }
    } else {
        $this.parent('.borderbot').addClass('error');
        return false;
    }
}

function validateEmail(element) {
    var $this = $(element);
    var value = $this.val();
    if (isNotNull(value)) {
        var result = checkEmail(value);
        if (!result.flag) {
            $this.parent('.borderbot').addClass('error');
            return false;
        } else {
            $this.parent('.borderbot').removeClass('error');
            return true;
        }
    } else {
        // $this.parent('.borderbot').addClass('error');
        return true;
    }
}

function validateNull(element) {
    var $this = $(element);
    var value = $this.val();
    if (isNotNull(value)) {
        $this.parent('.borderbot').removeClass('error');
        return true;
    } else {
        $this.parent('.borderbot').addClass('error');
        return false;
    }
}