function isNotNull(value) {
    //处理数字0
    if((typeof value) === 'number'){
        if(value == 0 ){
            return true;
        }
    }
    var flag = true;
    if (value == null || value == undefined || value == "") {
        flag = false;
    }
    else {
        flag = true;
    }
    return flag;
}

function isNotEmpty(value) {
    //处理数字0
    if((typeof value) === 'number'){
        if(value == 0 ){
            return true;
        }
    }
    if(value == undefined || value == null || value == '' || value=='undefined' || value == 'null' || value.length == 0){
        return false;
    }else {
        //处理非空格的字符串
        if((typeof value) === 'string'){
            if($.trim(value) == '' || $.trim(value).length == 0 ){
                return false;
            }
        }
        return true;
    }
}

/**
* 校验身份证
*
* @param code
*            15/18位身份证号码
* @return true：正确
*/
function checkIdentityNum(code) {
    var city = {
        11: "北京",
        12: "天津",
        13: "河北",
        14: "山西",
        15: "内蒙古",
        21: "辽宁",
        22: "吉林",
        23: "黑龙江 ",
        31: "上海",
        32: "江苏",
        33: "浙江",
        34: "安徽",
        35: "福建",
        36: "江西",
        37: "山东",
        41: "河南",
        42: "湖北 ",
        43: "湖南",
        44: "广东",
        45: "广西",
        46: "海南",
        50: "重庆",
        51: "四川",
        52: "贵州",
        53: "云南",
        54: "西藏 ",
        61: "陕西",
        62: "甘肃",
        63: "青海",
        64: "宁夏",
        65: "新疆",
        71: "台湾",
        81: "香港",
        82: "澳门",
        91: "国外 "
    };
    var tip = "";
    var pass = true;

    if (!code || !/^\d{6}(18|19|20)?\d{2}(0[1-9]|1[012])(0[1-9]|[12]\d|3[01])\d{2,3}(\d|X)$/i.test(code)) {
        tip = "身份证号格式错误";
        pass = false;
    }
    else if (code.length != 15 && code.length != 18) {
        tip = "身份证号格式错误";
        pass = false;
    }

    else if (!city[code.substr(0, 2)]) {
        tip = "地址编码错误";
        pass = false;
    }
    else {
        //18位身份证需要验证最后一位校验位
        if (code.length == 18) {
            code = code.split('');
            //∑(ai×Wi)(mod 11)
            //加权因子
            var factor = [7, 9, 10, 5, 8, 4, 2, 1, 6, 3, 7, 9, 10, 5, 8, 4, 2];
            //校验位
            var parity = [1, 0, 'X', 9, 8, 7, 6, 5, 4, 3, 2];
            var sum = 0;
            var ai = 0;
            var wi = 0;
            for (var i = 0; i < 17; i++) {
                ai = code[i];
                wi = factor[i];
                sum += ai * wi;
            }
            var last = parity[sum % 11];
            if (parity[sum % 11] != code[17]) {
                tip = "校验位错误";
                pass = false;
            }
        }
    }
    var result = {"flag": pass, "message": tip};
    return result;
}

/**
 * 校验组织机构代码证
 * 校验原理见：https://zh.wikisource.org/zh-hans/GB_11714-1997_%E5%85%A8%E5%9B%BD%E7%BB%84%E7%BB%87%E6%9C%BA%E6%9E%84%E4%BB%A3%E7%A0%81%E7%BC%96%E5%88%B6%E8%A7%84%E5%88%99
 * @param code
 */
function checkCodingForTheRepresentationOfOrganization(code) {
    // 临时屏蔽校验
   return true;

    // 定义权重：
    var powers = [3,7,9,10,5,8,4,2];
    var regx = /\d{8}-\d{1}/;

    if(regx.test(code)) {
        // 计算校验码
        var splited = code.split("-");
        var codeVerfiySign = Number(splited[1]);
        var codeNums = splited[0];
        // 权重总值
        var powerSum = 0;
        var sum = 0;
        for(var i = 0; i < codeNums.length; i++) {
            powerSum += Number(codeNums[i]) * powers[i];
        }
        // 计算余数
        var mod = powerSum % 11;
        var verfiyCode = 11 - mod;
        // 当余数为10时，使用X代替
        verfiyCode = verfiyCode == 10 ? 'X' : verfiyCode;

        return Number(verfiyCode) - codeVerfiySign == 0;


    } else {
        return false;
    }
}

/**
 * 根据身份证获取生日
 * @param val
 * @returns {*}
 */
function getbirthDayByIdNum(val) {
    var birthDayValue;

    if(isNotNull(val)) {
        val = $.trim(val);

        if (15 == val.length) { //15位身份证号码
            birthDayValue = val.charAt(6) + val.charAt(7);
            if (parseInt(birthDayValue) < 10) {
                birthDayValue = '20' + birthDayValue;
            } else {
                birthDayValue = '19' + birthDayValue;
            }
            birthDayValue = birthDayValue + '-' + val.charAt(8) + val.charAt(9) + '-' + val.charAt(10) + val.charAt(11);
        }
        if (18 == val.length) { //18位身份证号码
            birthDayValue = val.charAt(6) + val.charAt(7) + val.charAt(8) + val.charAt(9) + '-' + val.charAt(10) + val.charAt(11)
                + '-' + val.charAt(12) + val.charAt(13);
        }

        if (isValidDateTime(birthDayValue) === false) {
            birthDayValue = "";
        }
    }

    return birthDayValue;
}

function isValidDateTime(date) {
    var oldDate = new Date(date);
    if (oldDate == undefined || (typeof oldDate == "string" && oldDate.trim() == "" || oldDate == "Invalid Date")) {
        return false;
    }
    return true;
}

/**
 * 根据身份证获取性别
 * @param val
 * @returns {*}
 */
function getSexByIdNum(val) {

    val = $.trim(val);

    if (15 == val.length) { //15位身份证号码
        if (parseInt(val.charAt(14) / 2) * 2 != val.charAt(14)) {
            //'男';
            return "1";
        } else {//'女';
            return "2";
        }
    }
    if (18 == val.length) { //18位身份证号码
        if (parseInt(val.charAt(16) / 2) * 2 != val.charAt(16)) {
            //'男';
            return "1";
        } else {
            //'女';
            return "2";
        }
    }
}

/**
 * 根据出生日期算出年龄
 * @param strbirthDay
 * @returns {*}
 */
function getAgeBybirthDay(strbirthDay) {
    if(!isNotNull(strbirthDay)) {
        return 0
    }
    var returnAge;
    var strbirthDayArr = strbirthDay.split("-");
    var birthYear = strbirthDayArr[0];
    var birthMonth = strbirthDayArr[1];
    var birthDay = strbirthDayArr[2];

    var now = new Date();
    var nowYear = now.getFullYear();
    var nowMonth = now.getMonth() + 1;
    var nowDay = now.getDate();

    if (nowYear == birthYear) {
        returnAge = 0;//同年 则为0岁
    }
    else {
        var ageDiff = nowYear - birthYear; //年之差
        if (ageDiff > 0) {
            if (nowMonth == birthMonth) {
                var dayDiff = nowDay - birthDay;//日之差
                if (dayDiff < 0) {
                    returnAge = ageDiff - 1;
                }
                else {
                    returnAge = ageDiff;
                }
            }
            else {
                var monthDiff = nowMonth - birthMonth;//月之差
                if (monthDiff < 0) {
                    returnAge = ageDiff - 1;
                }
                else {
                    returnAge = ageDiff;
                }
            }
        }
        else {
            returnAge = -1;//返回-1 表示出生日期输入错误 晚于今天
        }
    }

    return returnAge;//返回周岁年龄

}


function getDateByDateParams(date, year, typeYear, month, typeMonth, day, typeDay) {
    var today = null;
    if (date == '' || date == undefined) {
        today = new Date();
    } else {
        if ((typeof date) === 'object') { //日期类型
            today = date;
        } else if (isNaN(date)) { //字符串类型
            var reg1 = /^([0-9]{4})(\-)([0-9]{1,2})(\-)([0-9]{1,2})$/;
            var reg2 = /^([0-9]{4})(\/)([0-9]{1,2})(\/)([0-9]{1,2})$/;
            if (reg1.test(date)) {
                var dateObj = date.split('-');
                today = new Date(dateObj[0], dateObj[1] - 1, dateObj[2]);
            } else if (reg2.test(date)) {
                var dateObj = date.split('/');
                today = new Date(dateObj[0], dateObj[1] - 1, dateObj[2]);
            } else {
                today = new Date(date);
            }
        } else { //时间戳类型
            today = new Date(date);
        }
    }
    if (year != '' && typeYear != '') {
        if (typeYear == '+') {
            today.setFullYear(today.getFullYear() + parseInt(year));
        } else {
            today.setFullYear(today.getFullYear() - parseInt(year));
        }
    }
    if (month != '' && typeMonth != '') {
        if (typeMonth == '+') {
            today.setMonth(today.getMonth() + parseInt(month));
        } else {
            today.setMonth(today.getMonth() - parseInt(month));
        }
    }
    if (day != '' && typeDay != '') {
        if (typeDay == '+') {
            today.setDate(today.getDate() + parseInt(day));
        } else {
            today.setDate(today.getDate() - parseInt(day));
        }
    }
    var Y = today.getFullYear();
    var M = today.getMonth() + 1;
    var D = today.getDate();
    if (M < 10) {
        M = "0" + M;
    }
    if (D < 10) {
        D = "0" + D;
    }
    return Y + '-' + M + '-' + D;
}

//校验手机号码：必须以数字开头，除数字外，可含有“-”
function checkMobile(elemStr) {
    var result = true;
    var oMobilePhone = elemStr;
    var reg = /^((13|14|15|16|17|18|19)\d{9,10})?$/;
    var reg2 = /(\d)\1{11}/;
    var message = "";
    var flag = true;
    var reg3 = /(^(?!(0123456|1234567|2345678|3456789)))(.(?!(0123456|1234567|2345678|3456789|9876543|8765432|7654321|6543210)))+$/g;
    if(oMobilePhone==""||oMobilePhone==null||oMobilePhone==undefined){
        message = "请输入手机号码";
        result = false;
        flag = false;
    }else if (!reg.test(oMobilePhone) || reg2.test(oMobilePhone) || !reg3.test(oMobilePhone)) {
        message = "手机号码不合规范，请您重新检查";
        result = false;
        flag = false;
    }
    var returnStrJson = {"flag": flag, "message": message};
    return returnStrJson;
}

function checkEmail(email) {
    var s = email;
    var message = "";
    var flag = true;
    var pattern = /^([a-zA-Z0-9_\-\.\+]+)@((\[[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\.)|(([a-zA-Z0-9\-]+\.)+))([a-zA-Z]{2,4}|[0-9]{1,3})(\]?)$/;
    if (!pattern.exec(s)) {
        message = "输入邮箱有误，请修改";
        flag = false;
    } else {
        flag = true;
    }
    var result = {"flag": flag, "message": message};
    return result;
}

function checkName(elementStr) {
    elementStr = $.trim(elementStr);
    var oriLength = elementStr.length;
    var charLength = chinese2EnglishLength(elementStr);
    var flag = true;
    var message = "";
    if (oriLength > 0) {
        var reg=/^[A-z]+$|^[\u4E00-\u9FA5\(\)（）]+$/;

        // if (!hasNoFull(elementStr)) {
        //     message = "姓名不能含有全角字符";
        //     flag = false;
        // }
        if (hasSpecialChar(elementStr)) {
            message = "姓名不能含有非法字符，如@#$";
            flag = false;
        }
        if (hasNum(elementStr)) {
            message = "姓名不能含有数字";
            flag = false;
        }
        if (charLength == oriLength * 2) {

            if (oriLength < 2 || oriLength > 40) {
                message = "中文姓名2-10个中文字符";
                flag = false;
                oriLength
            }else if(oriLength>=4){
                // var exp = new RegExp("[集团|公司|有限|股份|商店]");
                // if(exp.test(elementStr)){
                //     message = "用户名不合规";
                //     flag = false;
                // }
            }
        }
        if (charLength == oriLength && charLength > 0) {
            if (charLength < 4 || charLength > 100) {
                message = "英文姓名4-30个英文字符";
                flag = false;
            }
        }
    } else {
        message = "请输入姓名";
        flag = false;
    }
    var result = {"flag": flag, "message": message};
    return result;
}
function chinese2EnglishLength(str) {
    return str.replace(/[^\x00-\xff]/g, '**').length;
}
function hasNoFull(str) {
    for (var i = 0; i < str.length; i++) {
        strCode = str.charCodeAt(i);
        if ((strCode > 65248) || (strCode == 12288)) {
            return false;
        }
    }
    return true;
}
function hasSpecialChar(str) {
    // var txt = new RegExp("[ ,\\`,\\~,\\!,\\@,\#,\\$,\\%,\\^,\\+,\\*,\\&,\\\\,\\/,\\?,\\|,\\:,\\.,\\<,\\>,\\{,\\},\\',\\;,\\=,\"]");

    var txtRgx = /[,\`,\~,\!,\@,#,\$,\%,\^,\+,\*,\&,\\,\/,\?,\|,\:,\.,\<,\>,\{,\},\',\;,\=,"]/;
    return txtRgx.test(str);
}
function hasNum(str) {
    var reg = /[0-9]/;
    return reg.test(str);
}

function checkDateStr(dateStr){
    var reg1 = /^([0-9]{4})(\-)([0-9]{1,2})(\-)([0-9]{1,2})$/;
    var reg2 = /^([0-9]{4})(\/)([0-9]{1,2})(\/)([0-9]{1,2})$/;
    if (reg1.test(dateStr)) {
        return true;
    } else if (reg2.test(dateStr)) {
        return true;
    } else {
        return false;
    }
    return false;
}

function validateStartDate(startDateStr) {
    if (!checkDateStr(startDateStr)){
        return false;
    }
    var nowDate = new Date();
    var startDate = new Date(startDateStr);
    if(startDate.getTime() < nowDate.getTime()){
        return false;
    }else {
        return true;
    }
}

function validateCard(card) {
    var reg = /^[a-zA-Z0-9\(\)-]{1,21}$/;
    if(reg.test(card)){
        return true;
    }else {
        return false;
    }
}
/**
 * 车牌号校验
 * @param vehicleNumber
 * @returns {boolean}
 */
function checkVehicleNumber(vehicleNumber) {
    return /^(([京津沪渝冀豫云辽黑湘皖鲁新苏浙赣鄂桂甘晋蒙陕吉闽贵粤青藏川宁琼使领][A-Z](([0-9]{5}[DF])|([DF]([A-HJ-NP-Z0-9])[0-9]{4})))|([京津沪渝冀豫云辽黑湘皖鲁新苏浙赣鄂桂甘晋蒙陕吉闽贵粤青藏川宁琼使领][A-Z][A-HJ-NP-Z0-9]{4}[A-HJ-NP-Z0-9挂学警港澳使领]))$/.test(vehicleNumber);
    //
    // var result = false;
    //
    // if (vehicleNumber.length >= 7){
    //     var express = /^[京津沪渝冀豫云辽黑湘皖鲁新苏浙赣鄂桂甘晋蒙陕吉闽贵粤青藏川宁琼使领A-Z]{1}[A-Z]{1}[A-Z0-9]{4,8}$/;
    //     // var express = /^[京津沪渝冀豫云辽黑湘皖鲁新苏浙赣鄂桂甘晋蒙陕吉闽贵粤青藏川宁琼使领A-Z]{1}[A-Z]{1}[A-Z0-9]{4}[A-Z0-9挂学警港澳]{1}$/;
    //     result = express.test(vehicleNumber);
    // }
    // return result;
}

/**
 * 邮编校验
 * @param postCode
 */
function checkPostCode(postCode) {
    var reg = /^[0-9]{6}$/;
    return reg.test(postCode);
}