/**
 * 投保相关接口
 * @type {{}}
 */
var insureService = {

    /**
     * 确认投保
     * @param options {
     *     data: {},
     *     success: Function(),
     *     error: Function()
     * }
     */
    insurePayInfo: function (options) {
        var _this = this;
        options = $.extend({
            success: function (data) {
                window.location.href = '/sfzn/reinsurance/insureSms.do?recommendId=' + data.recommendId + ('&renewFlag=' + (data.isRenewal ? 1 : 0));
            },
            error: function (errCode, message) {
                if (isNotNull(message)) {
                    alert(message);
                } else {
                    alert('网络错误，请稍后重试！');
                }
            }
        }, options);
        var url = '/sfzn/reinsurance/insurePayInfo.do?recommendId=' + options.data.recommendId;
        ajaxRequest(url, options.data, function successCallback(data) {
            if (data.respCode == '0000') {
                if($.isFunction(options.success)) {
                    options.success.call(_this, {
                        recommendId: data.recommendId,
                        isRenewal: options.data.isRenewal
                    });
                    // window.location.href = '/sfzn/reinsurance/insureSms.do?recommendId=' + recommendId + ('&renewFlag=' + (options.data.isRenewal ? 1 : 0));
                }
                // alert("投保成功");
            } else {
                if($.isFunction(options.error)) {
                    options.error.call(_this, data.respCode, data.respMsg);
                }
            }
        }, function errorCallback(error) {
            if($.isFunction(options.error)) {
                options.error.call(_this, error, '网络错误，请稍后重试！');
            }
        });
    }
};