/**
 * 产品相关接口服务
 * @type {{getProductItem: productItemService.getProductItem, suitableProductItem: productItemService.suitableProductItem}}
 */
var productItemService = {

    /**
     * 获取产品方案
     * @param options: {
     *     data: {
     *         age: Number; 被保人年龄
     *         applicantIsSocialSe: String; 有无社保标志
     *         amountSelect: Number; 保额
     *         recommendId: String; 推荐投保ID
     *     }
     *     success: function(productItems); 成功回调
     *     error: function(errorCode, errorMessage); 失败回调
     * }
     */
    getProductItem: function(options) {
        var url = "/sfzn/reinsurance/getProductItem.do?recommendId=" + options.data.recommendId;
        var _this = this;
        ajaxRequest(url, options.data, function(data) {
            if (data.respCode == '0000') {
                if($.isFunction(options.success)) {
                    options.success.call(_this, data.productItem);
                }
            } else {
                if($.isFunction(options.error)) {
                    options.error.call(_this, data.respCode, data.respMsg);
                }
            }
        });
    },
    getProductItemRate: function(options) {
        var url = "/sfzn/reinsurance/getProductItemRate.do?recommendId=" + options.data.recommendId+"&productItemCode="+options.data.productItemCode;
        var _this = this;
        ajaxRequest(url, options.data, function(data) {
            if (data.respCode == '0000') {
                if($.isFunction(options.success)) {
                    options.success.call(_this, data);
                }
            } else {
                if($.isFunction(options.error)) {
                    options.error.call(_this, data.respCode, data.respMsg);
                }
            }
        });
    },
    /**
     * 选择合适的产品方案
     * @param params: {
     *     data: {
     *         productItems: [], // 可用产品列表
     *         isRenewal: Boolean // 是否续保
     *         lastClaimCount: Number //
     *     }
     *
     *     success: function(selectedProductItem) // 成功回调，返回参数selectedProductItem为可用产品方案
     *     error: function(errorCode, message) // 失败回调，返回参数：
     *                                         // errorCode - 错误代码
     *                                         // message - 错误信息
     * }
     */
    suitableProductItem: function(options) {
        options = $.extend({
            error: function (code, msg) {
                alert(code + ": " + msg);
            }
        }, options);
        // 是否包括了续保方案
        var hasRenewalItemFlag = false;
        // 是否包括了新保方案
        var hasNewItemFlag = false;
        if($.isArray(options.data.productItems)) {
            for (var i = 0; i < options.data.productItems.length; i ++) {
                if (options.data.productItems[i].renewalFlag == "0") {
                    // 同时支持新保续保
                    hasRenewalItemFlag = true;
                    hasNewItemFlag = true;
                }
                if (options.data.productItems[i].renewalFlag == "1") {
                    // 只支持续保
                    hasRenewalItemFlag = true;
                }
                if (options.data.productItems[i].renewalFlag == "2") {
                    // 只支持新保
                    hasNewItemFlag = true;
                }
            }
        } else {
            options.data.productItems = [options.data.productItems];
        }

        if(options.data.productItems.length <= 0) {
            // 没有合适的方案
            if($.isFunction(options.error)) {
                options.error.call(this, '1000', '没有合适的产品方案');
            }
            return ;
        }

        var selectedProductItem = options.data.productItems[0];

        if (hasRenewalItemFlag) {
            if(options.data.isRenewal) {
                // 续保
                // 续保时需筛选符合理赔情况的产品方案
                for (var i = 0; i < options.data.productItems.length; i ++) {
                    var extAttr = options.data.productItems[i].extArrt;
                    if ($.isEmptyObject(extAttr)) {

                        continue;
                    }
                    var obj = JSON.parse(extAttr);
                    var calimFlag = false;
                    // 判断是否有配置理赔下限
                    if(!(obj.calimCountLower==undefined || typeof obj.calimCountLower == 'undefined' || obj.calimCountLower==null) && obj.calimCountLower >= 0) {
                        calimFlag = true && options.data.lastClaimCount >= obj.calimCountLower;
                    }

                    // 判断是否有配置理赔上限
                    if(!(obj.calimCountHigher==undefined || typeof obj.calimCountHigher == 'undefined' || obj.calimCountHigher==null) && obj.calimCountHigher >= 0) {
                        calimFlag = calimFlag && options.data.lastClaimCount <= obj.calimCountHigher;
                    }

                    if(calimFlag) {
                        selectedProductItem =options.data.productItems[i];
                        break;
                    }

                }
                if($.isFunction(options.success)) {
                    options.success.call(this, selectedProductItem);
                }
                return selectedProductItem;
            } else {
                // 非续保
                if(!hasNewItemFlag) {
                    // 非续保且可用方案中没有新保方案时给出提示
                    if($.isFunction(options.error)) {
                        options.error.call(this, '1000', '没有合适的产品方案');
                    }
                } else {
                    if($.isFunction(options.success)) {
                        options.success.call(this, selectedProductItem);
                    }
                }
            }
        } else {
            productItem = options.data.productItems[0];
            if(typeof productItem == 'undefined' || productItem == null) {
                if($.isFunction(options.error)) {
                    options.error.call(this, '1000', '没有合适的产品方案');
                }
            } else {
                if($.isFunction(options.success)) {
                    options.success.call(this, selectedProductItem);
                }
                return productItem;
            }
        }
    }
};