/**
 * 续保相关接口服务
 * @type {{checkRenewal: renewalService.checkRenewal}}
 */
var renewalService = {
    /**
     * 判断是否续保
     * @param options {
     *     data: {
     *         recommendId: String; 推荐主表ID
     *         idnum: String; 被保险人身份证号
     *     },
     *     success: function(insureVo) //
     *     error: function() //
     * }
     */
    checkRenewal: function(options) {
        // 当方案中存在续保方案时，判断选取哪个方案
        var url = '/sfzn/renewal/renewal.do?recommendId=' + options.data.recommendId + '&idnum=' + options.data.idnum;
        // 调用接口获取是否续保
        var _this = this;
        ajaxRequest(url, {}, function (data) {
            if(data.respCode == "0000") {
                if($.isFunction(options.success)) {
                    options.success.call(_this, data);
                }
            } else {
                if($.isFunction(options.error)) {
                    options.error.call(_this, data.respCode, data.respMsg);
                }
            }
        }, function (error) {
            if($.isFunction(options.error)) {
                options.error.call(_this, "9000", error);
            }
        });

    }
};