/*
 * Decompiled with CFR 0.152.
 */
package com.picc.gz.utils;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.xml.DomDriver;
import java.lang.reflect.Field;

public class XmlUtil {
    private static <T> void setAnnotations(XStream xs, Class<T> cls) {
        Field[] f = cls.getDeclaredFields();
        for (int i = 0; i < f.length; ++i) {
            Field field = f[i];
            xs.processAnnotations(field.getType());
        }
    }

    public static <T> T toBean(String xml, Class<T> cls) {
        XStream xstream = new XStream((HierarchicalStreamDriver)new DomDriver("UTF-8"));
        xstream.processAnnotations(cls);
        return (T)xstream.fromXML(xml);
    }

    public static <T> T toBean(String xml, Class<?> ... cls) {
        XStream xstream = new XStream((HierarchicalStreamDriver)new DomDriver("UTF-8"));
        for (Class<?> class1 : cls) {
            xstream.processAnnotations(class1);
        }
        return (T)xstream.fromXML(xml);
    }

    public static String toXml(Object obj) {
        XStream xstream = new XStream((HierarchicalStreamDriver)new DomDriver("UTF-8"));
        xstream.autodetectAnnotations(true);
        xstream.alias(obj.getClass().getSimpleName(), obj.getClass());
        String xml = xstream.toXML(obj);
        return xml;
    }
}

