# 商非智能平台对外接口文档

## 一、 API调用方法

### 1. 接口地址

**生产：**

**测试：** 56.50.32.188:7001

###2.请求方式

**传输协议:**

- HTTP POST

**Content-Type:**

- application/json; charset=UTF-8

**请求数据结构**

- JSON
- 

## 二、 接口说明

### 1. 接口请求参数

|  字段  | 类型          | 是否必须 | 说明                                                     |
| :----: | ------------- | -------- | -------------------------------------------------------- |
| header | RequestHeader | 是       | 请求头信息                                               |
|  body  | Object        | 是       | 请求业务信息，根据不同接口需不同传值，详细请看各接口说明 |

#### 1.1. 请求头参数RequestHeader

| 字段      | 类型   | 是否必须 | 说明                                                         |
| --------- | ------ | -------- | ------------------------------------------------------------ |
| appId     | String | 是       | 接口调用方appId，一个调用方一个ID，由商非平台提供            |
| appKey    | String | 是       | 接口调用方appKey，一个appId可对应多个不同权限的appKey，由商非平台提供 |
|           |        |          |                                                              |
| timeStamp | Date   | 是       | 调用时间戳，转换成JSON时的格式：yyyy-MM-dd HH:mm:ss.SSS      |
| sign      | String | 是       | 签名字符串，详见签名字符串算法                               |
|           |        |          |                                                              |

####1.2. 签名字符串算法

1. 将所有参数按照ascii升序排序，所有日期都统一格式化为yyyyMMddHHmmssSSS

   ```
   {
       header: {
           appId:ee0272c4-db40-11e8-922e-28924a378ce0,
           appKey:sfzn_a8639fd95ff7f69dfef9a04d0225cf96,
           timeStamp:20181031145501987
       },
       body: {
       	agentcode: 00000001,
           comCode: 440100
           
       }
   }
   ```

2. 将所有参数转换成参数名=参数值，形式，参数之间用&连接，sign参数不需要参与拼接

   ```
   header.appId=ee0272c4-db40-11e8-922e-28924a378ce0&header.appKey=sfzn_a8639fd95ff7f69dfef9a04d0225cf96&timeStamp=20181031145501987&body.agentcode=00000001&comCode=440100
   ```

3. 在生成的参数串后加拼接appSecret

   ```
   header.appId=ee0272c4-db40-11e8-922e-28924a378ce0&header.appKey=sfzn_a8639fd95ff7f69dfef9a04d0225cf96&timeStamp=20181031145501987&body.agentcode=00000001&comCode=440100&appSecret=A790805CDAF7234B479BC0273B36EF17F9F57CAF
   ```

4. 对参数串做SHA-1加密，结果全部转换成大写

### 2. 请求报文样例

```
{
    header: {
        appId:ee0272c4-db40-11e8-922e-28924a378ce0,
        appKey:sfzn_a8639fd95ff7f69dfef9a04d0225cf96,
        timeStamp:20181031145501987,
        sign: A790805CDAF7234B479BC0273B36EF17F9F57CAF
    },
    body: {
    	agentcode: 00000001,
        comCode: 440100
    }
}
```



### 3. 返回参数

| 字段        | 类型    | 是否必须 | 说明                                           |
| ----------- | ------- | -------- | ---------------------------------------------- |
| successFlag | Boolean | 是       | 接口处理是否成功，true成功，false失败          |
| errorCode   | String  | 否       | 当successFlag为false时有值，标识错误对应的代码 |
| message     | String  | 否       | 当successFlag为false时有值，返回错误信息       |
| data        | Object  | 是       | 业务返回数据，不同的接口返回业务数据不同       |
|             |         |          |                                                |
|             |         |          |                                                |

### 4. 返回报文样例：

```
{
    successFlag:true,
    errorCode:0000,
    message:'successed',
    data: {
    	url: 'http://www.baidu.com',
        recommendId: 1
    }
}
```



##三、接口明细

### 1.推荐商机生成接口

- 接口路径: /api/recommend

- API功能描述：推送一笔推荐投保商机，成功时返回该客户的投保url

- 请求方式：POST

- 业务参数：

  | 字段         | 类型   | 是否必须 | 说明                                                         |
  | ------------ | ------ | -------- | ------------------------------------------------------------ |
  | comCode      | String | 是       | 归属机构码                                                   |
  | makeCode     | String | 是       | 出单机构码                                                   |
  | handlerCode  | String | 是       | 经办人码                                                     |
  | handler1Code | String | 是       | 归属业务员码                                                 |
  | operatorCode | String | 是       | 操作员码                                                     |
  | sellerno     | String | 是       | 销售人员码                                                   |
  | sellername   | String | 是       | 销售人员名字                                                 |
  | agentcode    | String | 是       | 渠道码                                                       |
  | customId     | String | 是       | 客户ID（标识客户画像中的客户标识）                           |
  | customerName | String | 是       | 客户姓名                                                     |
  | idType       | String | 是       | 证件类型：
 01  --  身份证
 02  --   户口薄
 03   --  护照
 04   --  军人证件
 05   --  驾驶执照
 06   --  返乡证
 07   --  港澳身份证
 08   --  工号
 09   --  赴台通行证
 10   --  港澳通行证
 15   --  士兵证
 21   --  外国护照
 22   --  旅行证
 23   --  回乡证
 24  --   居留证件
 25   --  港澳居民来往内地通行证
 26   --  台湾居民来往内地通行证
 29   --  其他个人证件
 31  --  组织机构代码证
 32   --  工商登记证
 33   --  税务登记证
 34   --  营业执照
 99   --  其他
 37   --  统一社会信用代码 |
  | idNumber     | String |          | 证件号                                                       |
  | gender       | Number | 是       | 性别：1--男 2--女                                            |
  | birthDay     | String | 否       | 生日，转换成JSON时的格式：yyyy-MM-dd HH:mm:ss.SSS，如"1989-01-01 00:00:00.000" |
  | mobile       | String | 是       | 手机                                                         |
  | email        | String | 否       | 邮箱                                                         |
  | address      | String | 是       | 家庭地址（全）                                               |

- 返回参数：

  | 字段        | 类型   | 是否必须 | 说明          |
  | ----------- | ------ | -------- | ------------- |
  | url         | String | 是       | 投保页面的URL |
  | recommendId | String | 是       | 推荐ID        |
  |             |        |          |               |


## 四、SDK及Demo

本接口提供Java版本的SDK，包括请求及返回参数的实体类、各参数常量、异常、签名工具等。

### 1. 引入接口SDK依赖

1. 添加以下maven仓库

2. 加入Maven依赖

### 2. 请求实体

###3. 签名工具

### 4. 返回实体

### 5. 快速Demo

