package com.picc.gz.sfzn.api.vo.recommend;

import com.alibaba.fastjson.annotation.JSONField;
import com.picc.gz.sfzn.api.ApiConstants;
import com.picc.gz.sfzn.api.vo.basic.RequestBody;

import java.util.Date;
import java.util.List;

/**
 * 推荐投保推送请求体
 * @author Liang Wenxu
 * @since 2018/10/29
 */
public class RecommendRequest implements RequestBody {

    /**
     * 险种信息，可传多个
     */
    List<RecommendRiskInfo> riskInfo;

    /**
     * 客户ID（标识客户画像中的客户标识）
     */
    private String customId;

    /**
     * 客户姓名
     */
    private String customerName;
    /**
     * 证件类型：
     * 01  --  身份证
     * 02  --   户口薄
     * 03   --  护照
     * 04   --  军人证件
     * 05   --  驾驶执照
     * 06   --  返乡证
     * 07   --  港澳身份证
     * 08   --  工号
     * 09   --  赴台通行证
     * 10   --  港澳通行证
     * 15   --  士兵证
     * 21   --  外国护照
     * 22   --  旅行证
     * 23   --  回乡证
     * 24  --   居留证件
     * 25   --  港澳居民来往内地通行证
     * 26   --  台湾居民来往内地通行证
     * 29   --  其他个人证件
     * 31  --  组织机构代码证
     * 32   --  工商登记证
     * 33   --  税务登记证
     * 34   --  营业执照
     * 99   --  其他
     * 37   --  统一社会信用代码
     */
    private String idType;
    /**
     * 证件号
     */
    private String idNumber;
    /**
     * 性别：1--男 2--女
     */
    private Integer gender;
    /**
     * 生日
     */
    @JSONField(format = ApiConstants.TIMESTRAMP_FORMAT_STRING)
    private Date birthDay;
    /**
     * 手机
     */
    private String mobile;
    /**
     * 邮箱
     */
    private String email;
    /**
     * 家庭地址（全）
     */
    private String address;

    /**
     * 坐席工号
     */
    private String tsUserCode;

    /**
     * 坐席电话
     */
    private String tsUserPhone;

    public String getCustomId() {
        return customId;
    }

    public void setCustomId(String customId) {
        this.customId = customId;
    }

    public String getCustomerName() {
        return customerName;
    }

    public void setCustomerName(String customerName) {
        this.customerName = customerName;
    }

    public String getIdType() {
        return idType;
    }

    public void setIdType(String idType) {
        this.idType = idType;
    }

    public String getIdNumber() {
        return idNumber;
    }

    public void setIdNumber(String idNumber) {
        this.idNumber = idNumber;
    }

    public Integer getGender() {
        return gender;
    }

    public void setGender(Integer gender) {
        this.gender = gender;
    }

    public Date getBirthDay() {
        return birthDay;
    }

    public void setBirthDay(Date birthDay) {
        this.birthDay = birthDay;
    }

    public String getMobile() {
        return mobile;
    }

    public void setMobile(String mobile) {
        this.mobile = mobile;
    }

    public String getEmail() {
        return email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getAddress() {
        return address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public String getTsUserCode() {
        return tsUserCode;
    }

    public void setTsUserCode(String tsUserCode) {
        this.tsUserCode = tsUserCode;
    }

    public String getTsUserPhone() {
        return tsUserPhone;
    }

    public void setTsUserPhone(String tsUserPhone) {
        this.tsUserPhone = tsUserPhone;
    }

    public List<RecommendRiskInfo> getRiskInfo() {
        return riskInfo;
    }

    public void setRiskInfo(List<RecommendRiskInfo> riskInfo) {
        this.riskInfo = riskInfo;
    }
}
