package com.picc.gz.sfzn.api;

import sun.swing.plaf.synth.DefaultSynthStyle;

/**
 * 接口常量
 */
public class ApiConstants {
    /**
     * HTTP请求的默认ContentType
     */
    public final static String HTTP_REQUEST_DEFAULT_CONTENT_TYPE = "application/json";
    /**
     * Http请求的默认字符集
     */
    public final static String HTTP_REQUEST_DEFAULT_CHARSET= "UTF-8";
    /**
     * 时间戳格式
     */
    public final static String TIMESTRAMP_FORMAT_STRING = "yyyy-MM-dd HH:mm:ss.SSS";

    /**
     * API返回默认信息，一般成功时用
     */
    public final static String BASE_RESPONSE_DEFAULT_MESSAGE = "成功";
    /**
     * API返回错误代码-成功
     */
    public final static String BASE_RESPONSE_ERRORCODE_SUCCESS = "0000";
    /**
     * API返回错误代码-业务数据为空
     */
    public final static String BASE_RESPONSE_ERRORCODE_EMPTYBODY = "1001";
    /**
     * API返回错误代码-获取不到HEADER
     */
    public final static String BASE_RESPONSE_ERRORCODE_ACCESSDENIED = "2001";
    /**
     * API返回错误代码-签名校验失败
     */
    public final static String BASE_RESPONSE_ERRORCODE_SIGNERROR = "2002";
    /**
     * API返回错误代码-获取不到BaseRequest参数，不要乱用ApiService注解
     */
    public final static String BASE_RESPONSE_ERRORCODE_REQUESTNOTFOUND = "9001";
    /**
     * API返回错误代码-获取不到HEADER
     */
    public final static String BASE_RESPONSE_ERRORCODE_HEADERNOTFOUND = "9002";

    /**
     * 证件类型
     */
    public static class IdTypes {
        /**
         * 身份证
         */
        public final static String IDCARD = "01";
        /**
         * 户口薄
         */
        public final static String HUKOU = "02";
        /**
         * 护照
         */
        public final static String PASSPORT = "03";
        /**
         * 军人证件
         */
        public final static String MILITARY = "04";
        /**
         * 驾驶执照
         */
        public final static String DRIVING_LICENSE = "05";
        /**
         * 返乡证
         */
        public final static String HOME_PERMIT = "06";
        /**
         * 港澳身份证
         */
        public final static String HK_MC_IDCARD = "07";
        /**
         * 工号
         */
        public final static String EMPLOYEE_NUMBER = "08";
        /**
         * 赴台通行证
         */
        public final static String TAIWAN_PASS = "09";
        /**
         * 港澳通行证
         */
        public final static String HK_MC_PASS = "10";
        /**
         * 士兵证
         */
        public final static String SOLDIER_CARD = "15";
        /**
         * 外国护照
         */
        public final static String FOREIGN_PASSPORT = "21";
        /**
         * 旅行证
         */
        public final static String TRAVEL_LICENSE = "22";
        /**
         * 回乡证
         */
        public final static String HOME_LICENSE = "23";
        /**
         * 居留证件
         */
        public final static String RESIDENCE_DOCUMENT = "24";
        /**
         * 港澳居民来往内地通行证
         */
        public final static String HK_MC_MAINLAND_PASS = "25";
        /**
         * 台湾居民来往内地通行证
         */
        public final static String TW_MAINLAND_PASS = "26";
        /**
         * 其他个人证件
         */
        public final static String OTHER_PERSONAL = "29";
        /**
         * 组织机构代码证
         */
        public final static String ORGANIZATION_CERTIFICATE = "31";
        /**
         * 工商登记证
         */
        public final static String BUSINESS_REGISTRATION_CERTIFICATE = "32";
        /**
         * 税务登记证
         */
        public final static String TAX_REGISTRATION_CERTIFICATE = "33";
        /**
         * 营业执照
         */
        public final static String BUSINESS_LICENSE = "34";
        /**
         * 其他
         */
        public final static String OTHER = "99";
        /**
         * 统一社会信用代码
         */
        public final static String UNIFIED_SOCIAL_CREDIT_CODE = "37";
    }

    /**
     * 性别
     */
    public static class Gender {
        public final static Integer MALE = 1;
        public final static Integer FEMALE = 2;
    }
}
