/*
 * Decompiled with CFR 0.152.
 */
package com.picc.gz.sfzn.api.security;

import com.picc.gz.sfzn.api.vo.basic.BaseRequest;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.security.MessageDigest;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;

public class SignUtil {
    private static ThreadLocal<DateFormat> dateFormat = new ThreadLocal();
    private static final char[] HEX_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    private static DateFormat getDateFormater() {
        DateFormat f = dateFormat.get();
        if (f == null) {
            f = new SimpleDateFormat("yyyyMMddHHmmssSSS");
            dateFormat.set(f);
        }
        return f;
    }

    private static String getFormattedText(byte[] bytes) {
        int len = bytes.length;
        StringBuilder buf = new StringBuilder(len * 2);
        for (int j = 0; j < len; ++j) {
            buf.append(HEX_DIGITS[bytes[j] >> 4 & 0xF]);
            buf.append(HEX_DIGITS[bytes[j] & 0xF]);
        }
        return buf.toString();
    }

    public static String signRequest(BaseRequest request, String secret) throws IntrospectionException, InvocationTargetException, IllegalAccessException {
        String signStr = String.format("%s&secret=%s", SignUtil.getParamStr(request), secret);
        System.out.println("\u751f\u6210\u7684\u7b7e\u540d\u5b57\u7b26\u4e32\uff1a" + signStr);
        String sign = SignUtil.encodeSHA1(signStr).toUpperCase();
        System.out.println("\u751f\u6210\u7684\u7b7e\u540d\uff1a" + sign);
        return sign;
    }

    public static String getParamStr(BaseRequest request) throws IntrospectionException, InvocationTargetException, IllegalAccessException {
        TreeMap<String, String> signMap = new TreeMap<String, String>(new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return o1.compareTo(o2);
            }
        });
        signMap.put("header.appId", request.getHeader().getAppId());
        signMap.put("header.appKey", request.getHeader().getAppKey());
        if (request.getHeader().getTimeStamp() != null) {
            signMap.put("header.timeStamp", SignUtil.getDateFormater().format(request.getHeader().getTimeStamp()));
        }
        if (request.getBody() != null) {
            PropertyDescriptor[] descriptorSrc;
            BeanInfo srcBeanInfo = Introspector.getBeanInfo(request.getBody().getClass());
            for (PropertyDescriptor property : descriptorSrc = srcBeanInfo.getPropertyDescriptors()) {
                SortedMap<String, String> childMap = SignUtil.getSignMap("body." + property.getName(), property.getReadMethod().invoke(request.getBody(), new Object[0]));
                signMap.putAll(childMap);
            }
        }
        StringBuilder signBuilder = new StringBuilder();
        for (Map.Entry m : signMap.entrySet()) {
            signBuilder.append("&").append((String)m.getKey()).append("=").append((String)m.getValue());
        }
        return signBuilder.substring(1);
    }

    private static SortedMap<String, String> getSignMap(String basicName, Object object) throws IntrospectionException, InvocationTargetException, IllegalAccessException {
        TreeMap<String, String> signMap;
        block7: {
            block9: {
                block8: {
                    signMap = new TreeMap<String, String>();
                    if (object == null) break block7;
                    if (!(object instanceof Date)) break block8;
                    signMap.put(basicName, SignUtil.getDateFormater().format(object));
                    break block7;
                }
                if (!SignUtil.isBaseType(object.getClass())) break block9;
                if (basicName.contains(".class")) break block7;
                signMap.put(basicName, object.toString());
                break block7;
            }
            if (object.getClass().isArray()) {
                int i = 0;
                for (Object o : (Object[])object) {
                    SortedMap<String, String> childMap = SignUtil.getSignMap(basicName + "[" + i + "].", o);
                    signMap.putAll(childMap);
                    ++i;
                }
            } else if (object instanceof Collection) {
                Collection collection = (Collection)object;
                Iterator it = collection.iterator();
                int i = 0;
                while (it.hasNext()) {
                    SortedMap<String, String> childMap = SignUtil.getSignMap(basicName + "[" + i + "].", it.next());
                    signMap.putAll(childMap);
                    ++i;
                }
            } else {
                PropertyDescriptor[] descriptorSrc;
                BeanInfo srcBeanInfo = Introspector.getBeanInfo(object.getClass());
                for (PropertyDescriptor pd : descriptorSrc = srcBeanInfo.getPropertyDescriptors()) {
                    SortedMap<String, String> childMap = SignUtil.getSignMap(basicName + pd.getName(), pd.getReadMethod().invoke(object, new Object[0]));
                    signMap.putAll(childMap);
                }
            }
        }
        return signMap;
    }

    public static String encodeSHA1(String source) {
        if (source == null) {
            return null;
        }
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("SHA1");
            messageDigest.update(source.getBytes("UTF-8"));
            return SignUtil.getFormattedText(messageDigest.digest());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static boolean isBaseType(Class<?> type) {
        if (type.isPrimitive()) {
            return true;
        }
        if (CharSequence.class.isAssignableFrom(type)) {
            return true;
        }
        if (Number.class.isAssignableFrom(type)) {
            return true;
        }
        if (Date.class.isAssignableFrom(type)) {
            return true;
        }
        if (Boolean.class.equals(type)) {
            return true;
        }
        if (Character.class.equals(type)) {
            return true;
        }
        if (Class.class.equals(type)) {
            return true;
        }
        if (StringBuilder.class.equals(type)) {
            return true;
        }
        if (StringBuffer.class.equals(type)) {
            return true;
        }
        if (Object.class.equals(type)) {
            return true;
        }
        return Void.class.equals(type);
    }
}

