package com.picc.gz.sfzn.api.vo.basic;

import java.io.Serializable;
import java.util.Date;

/**
 * 分页查询基类
 * @author Liang Wenxu
 * @since 2018/11/23
 */
public class PageableQueryRequest implements Serializable {
    /**
     * 当前页，1代表第一页
     */
    private int page;

    /**
     * 每页数据量
     */
    private int size;

    /**
     * 排序
     */
    private Sort sort;

    public PageableQueryRequest(int page, int size, Sort.Direction direction, String... properties) {
        this(page, size, new Sort(direction, properties));
    }

    public PageableQueryRequest(int page, int size) {
        this(page, size, null);
    }

    public PageableQueryRequest(int page, int size, Sort sort) {
        this.page = page;
        this.size = size;
        this.sort = sort;
    }

    public int getPage() {
        return page;
    }

    public int getSize() {
        return size;
    }

    public Sort getSort() {
        return sort;
    }

    public void setPage(int page) {
        this.page = page;
    }

    public void setSize(int size) {
        this.size = size;
    }

    public void setSort(Sort sort) {
        this.sort = sort;
    }
}
