package com.picc.gz.sfzn.api.vo.recommend;

import com.picc.gz.sfzn.api.vo.basic.PageableQueryRequest;
import com.picc.gz.sfzn.api.vo.basic.RequestBody;
import com.picc.gz.sfzn.api.vo.basic.Sort;

import java.util.Date;

/**
 * @author Liang Wenxu
 * @since 2018/11/23
 */
public class PolicyQueryRequest extends PageableQueryRequest implements RequestBody {
    /**
     * 证件号
     */
    private String idNum;
    /**
     * 保单生成时间开始
     */
    private Date policyTimeStart;
    /**
     * 保单生成时间结束
     */
    private Date policyTimeEnd;

    public PolicyQueryRequest() {
        super(0, 0, null);
    }

    public PolicyQueryRequest(int page, int size, Sort.Direction direction, String... properties) {
        super(page, size, direction, properties);
    }

    public PolicyQueryRequest(int page, int size) {
        super(page, size);
    }

    public PolicyQueryRequest(int page, int size, Sort sort) {
        super(page, size, sort);
    }

    public String getIdNum() {
        return idNum;
    }

    public void setIdNum(String idNum) {
        this.idNum = idNum;
    }

    public Date getPolicyTimeStart() {
        return policyTimeStart;
    }

    public void setPolicyTimeStart(Date policyTimeStart) {
        this.policyTimeStart = policyTimeStart;
    }

    public Date getPolicyTimeEnd() {
        return policyTimeEnd;
    }

    public void setPolicyTimeEnd(Date policyTimeEnd) {
        this.policyTimeEnd = policyTimeEnd;
    }
}
