package com.picc.gz.sfzn.api.vo.basic;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;

import java.io.Serializable;
import java.util.List;

/**
 * 基本请求对象
 *
 * @author Liang Wenxu
 * @since 2018/10/29
 */
public class BaseRequest<T extends RequestBody> implements Serializable {
    public static final String JSON_KEY_HEADER = "header";
    public static final String JSON_KEY_BODY = "body";

    /**
     * 请求头
     */
    private RequestHeader header;
    /**
     * 请求体
     */
    private T body;

    public String toJson() {
        return JSON.toJSONString(this);
    }

    /**
     * 将JSON转换为Request, 适用于body是类的情况
     *
     * @param json  JSON串
     * @param clazz body的类型
     * @param <T>   类型的泛型，使用 BaseRequest<MyBody> request = BaseRequest.fromJSONObject(jsonStr, MyBody.class);
     * @return
     */
    public static <T extends RequestBody> BaseRequest<T> fromJSONObject(String json, Class<T> clazz) {
        BaseRequest<T> request = new BaseRequest<>();
        JSONObject jsonObject = JSON.parseObject(json);
        request.header = jsonObject.getJSONObject(JSON_KEY_HEADER).toJavaObject(RequestHeader.class);
        request.body = jsonObject.getJSONObject(JSON_KEY_BODY).toJavaObject(clazz);
        return request;
    }

    public RequestHeader getHeader() {
        return header;
    }

    public void setHeader(RequestHeader header) {
        this.header = header;
    }

    public T getBody() {
        return body;
    }

    public void setBody(T body) {
        this.body = body;
    }

    @Override
    public String toString() {
        return "BaseRequest{" +
                "header=" + header +
                ", body=" + body.toString() +
                '}';
    }
}
