package com.picc.gz.sfzn.api;

import com.alibaba.fastjson.JSON;
import com.picc.gz.sfzn.api.security.SignUtil;
import com.picc.gz.sfzn.api.vo.basic.BaseRequest;
import com.picc.gz.sfzn.api.vo.basic.BaseResponse;
import com.picc.gz.sfzn.api.vo.basic.RequestHeader;
import com.picc.gz.sfzn.api.vo.recommend.RecommendRequest;
import com.picc.gz.sfzn.api.vo.recommend.RecommendResp;
import okhttp3.*;

import java.beans.IntrospectionException;
import java.lang.reflect.InvocationTargetException;
import java.util.Date;

/**
 * @author Liang Wenxu
 * @since 2020-3-10
 */
public class SfznRecommendApi {
    /**
     * 接口部署主机
     */
    private String host;

    /**
     * 接口监听端口
     */
    private String port;

    private String appSecret;

    private String appId;

    private String appKey;

    public SfznRecommendApi() {
    }

    public SfznRecommendApi(String host, String port, String appSecret, String appId, String appKey) {
        this.host = host;
        this.port = port;
        this.appSecret = appSecret;
        this.appId = appId;
        this.appKey = appKey;
    }

    public SfznRecommendApi(SfznRecommendApi other) {
        this.host = other.host;
        this.port = other.port;
        this.appSecret = other.appSecret;
        this.appId = other.appId;
        this.appKey = other.appKey;
    }

    public BaseResponse<RecommendResp> recommend(RecommendRequest body, String url) throws IllegalAccessException, IntrospectionException, InvocationTargetException {
        OkHttpClient.Builder builder = new OkHttpClient.Builder();
        OkHttpClient okHttpClient = builder.build();
        BaseRequest<RecommendRequest> request = new BaseRequest<>();
        RequestHeader requestHeader = new RequestHeader();
        requestHeader.setAppId(appId);
        requestHeader.setAppKey(appKey);
        requestHeader.setTimeStamp(new Date());
        request.setHeader(requestHeader);
        request.setBody(body);
        String sign = SignUtil.signRequest(request, appSecret);
        requestHeader.setSign(sign);
        final MediaType JSON_TYPE = MediaType.parse(ApiConstants.HTTP_REQUEST_DEFAULT_CONTENT_TYPE
                + "; charset=" + ApiConstants.HTTP_REQUEST_DEFAULT_CHARSET);
        String requestJson = JSON.toJSONString(request);
        System.out.println("requestJson: " + requestJson);
        RequestBody requestBody = RequestBody.create(JSON_TYPE, requestJson);


        Request httpRequest = new Request.Builder()
                .url(String.format("http://%s:%s/sfzn/api/recommend", host, port))
                .post(requestBody)
                .build();

        try {
            Response response = okHttpClient.newCall(httpRequest).execute();
            String responseBody = response.body().string();
//            log.info("responseBody-->{}", responseBody);
//            if(responseBody == null || responseBody.trim().length() <= 0){
//                log.info("服务器返回信息为空");
//            }else {
//                log.info("服务器返回的信息-->{}", responseBody);
//            }

            response = okHttpClient.newCall(httpRequest).execute();
            responseBody = response.body().string();
//            log.info("responseBody-->{}", responseBody);
            if (responseBody == null || responseBody.trim().length() <= 0) {
//                log.info("服务器返回信息为空");
                return BaseResponse.createError("1001", "服务器返回信息为空");
            } else {
//                log.info("服务器返回的信息-->{}", responseBody);
                return BaseResponse.createSuc(JSON.parseObject(responseBody, RecommendResp.class));
            }
        } catch (Exception e) {
            e.printStackTrace();
            return BaseResponse.createError("1002", e.getLocalizedMessage());
        }
    }


    public String getHost() {
        return host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public String getPort() {
        return port;
    }

    public void setPort(String port) {
        this.port = port;
    }

    public String getAppSecret() {
        return appSecret;
    }

    public void setAppSecret(String appSecret) {
        this.appSecret = appSecret;
    }

    public String getAppId() {
        return appId;
    }

    public void setAppId(String appId) {
        this.appId = appId;
    }

    public String getAppKey() {
        return appKey;
    }

    public void setAppKey(String appKey) {
        this.appKey = appKey;
    }
}
