package com.picc.gz.sfzn.api.vo.basic;

import com.picc.gz.sfzn.api.ApiConstants;

import java.io.Serializable;

/**
 * API接口基础返回
 *
 * @author Liang Wenxu
 * @since 2018/10/29
 */
public class BaseResponse<T> implements Serializable {
    /**
     * 成功标志
     */
    private Boolean successFlag;
    /**
     * 错误代码
     */
    private String errorCode;
    /**
     * 错误信息
     */
    private String message;
    /**
     * 返回对象
     */
    private T data;

    public static <T> BaseResponse<T> createSuc(T data) {
        BaseResponse baseResponse = new BaseResponse();
        baseResponse.setSuccessFlag(true);
        baseResponse.setErrorCode(ApiConstants.BASE_RESPONSE_ERRORCODE_SUCCESS);
        baseResponse.setMessage(ApiConstants.BASE_RESPONSE_DEFAULT_MESSAGE);
        baseResponse.setData(data);
        return baseResponse;
    }

    public static BaseResponse createError(String errorCode, String message) {
        BaseResponse baseResponse = new BaseResponse();
        baseResponse.setSuccessFlag(false);
        baseResponse.setMessage(message);
        baseResponse.setErrorCode(errorCode);
        return baseResponse;
    }

    public Boolean getSuccessFlag() {
        return successFlag;
    }

    public void setSuccessFlag(Boolean successFlag) {
        this.successFlag = successFlag;
    }

    public String getErrorCode() {
        return errorCode;
    }

    public void setErrorCode(String errorCode) {
        this.errorCode = errorCode;
    }

    public String getMessage() {
        return message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public T getData() {
        return data;
    }

    public void setData(T data) {
        this.data = data;
    }

    @Override
    public String toString() {
        return "BaseResponse{" +
                "successFlag=" + successFlag +
                ", errorCode='" + errorCode + '\'' +
                ", message='" + message + '\'' +
                ", data=" + data +
                '}';
    }
}
