package com.picc.gz.sfzn.api.vo.recommend;

import lombok.Builder;

import java.io.Serializable;
import java.util.List;

/**
 * 推荐险种信息
 * @author Liang Wenxu
 * @since 2018/11/19
 */
public class RecommendRiskInfo implements Serializable {
    /**
     * 险种代码
     * 如WBK、EDD等
     */
    private String riskCode;
    /**
     * 产品代码，可选，如有传值，则投保页面会默认选中planCode指定的产品
     * 如：EDD4400040等
     */
    private String planCode;

    /**
     * 销售人员信息（多个）
     */
    private List<SalerInfo> salerInfos;

    public String getRiskCode() {
        return riskCode;
    }

    public void setRiskCode(String riskCode) {
        this.riskCode = riskCode;
    }

    public String getPlanCode() {
        return planCode;
    }

    public void setPlanCode(String planCode) {
        this.planCode = planCode;
    }

    public List<SalerInfo> getSalerInfos() {
        return salerInfos;
    }

    public void setSalerInfos(List<SalerInfo> salerInfos) {
        this.salerInfos = salerInfos;
    }

    @Override
    public String toString() {
        return "RecommendRiskInfo{" +
                "riskCode='" + riskCode + '\'' +
                ", planCode='" + planCode + '\'' +
                ", salerInfos=" + salerInfos +
                '}';
    }
}
