# 商非智能平台对外接口文档

## 一、 API调用方法

### 1. 接口地址

**生产：**

**测试：** http://56.1.88.169:8088/sfzn/

**各接口的访问URL:** <接口地址>+<接口路径>，如推荐商机推送接口的测试环境URL为 http://56.1.88.169:8088/sfzn/api/recommend

###2.请求方式

**传输协议:**

- HTTP POST

**Content-Type:**

- application/json; charset=UTF-8

**请求数据结构**

- JSON
- 

## 二、 接口说明

### 1. 接口请求参数

|  字段  | 类型          | 是否必须 | 说明                                                     |
| :----: | ------------- | -------- | -------------------------------------------------------- |
| header | RequestHeader | 是       | 请求头信息                                               |
|  body  | Object        | 是       | 请求业务信息，根据不同接口需不同传值，详细请看各接口说明 |

#### 1.1. 请求头参数RequestHeader

| 字段      | 类型   | 是否必须 | 说明                                                         |
| --------- | ------ | -------- | ------------------------------------------------------------ |
| appId     | String | 是       | 接口调用方appId，一个调用方一个ID，由商非平台提供            |
| appKey    | String | 是       | 接口调用方appKey，一个appId可对应多个不同权限的appKey，由商非平台提供 |
|           |        |          |                                                              |
| timeStamp | Date   | 是       | 调用时间戳，转换成JSON时的格式：yyyy-MM-dd HH:mm:ss.SSS      |
| sign      | String | 是       | 签名字符串，详见签名字符串算法                               |
|           |        |          |                                                              |

####1.2. 签名字符串算法

1. 将所有参数按照ascii升序排序，所有日期都统一格式化为yyyyMMddHHmmssSSS

   ```json
   {
       body: {
       	agentcode: 00000001,
           comCode: 440100
           
       },
       header: {
           appId:ee0272c4-db40-11e8-922e-28924a378ce0,
           appKey:sfzn_a8639fd95ff7f69dfef9a04d0225cf96,
           timeStamp:20181031145501987
       }
   }
   ```

2. 将所有参数转换成参数名=参数值，形式，参数之间用&连接，sign参数不需要参与拼接

   ```
   header.appId=ee0272c4-db40-11e8-922e-28924a378ce0&header.appKey=sfzn_a8639fd95ff7f69dfef9a04d0225cf96&timeStamp=20181031145501987&body.agentcode=00000001&comCode=440100
   ```

3. 在生成的参数串后加拼接appSecret

   ```
   header.appId=ee0272c4-db40-11e8-922e-28924a378ce0&header.appKey=sfzn_a8639fd95ff7f69dfef9a04d0225cf96&timeStamp=20181031145501987&body.agentcode=00000001&comCode=440100&appSecret=A790805CDAF7234B479BC0273B36EF17F9F57CAF
   ```

4. 对参数串做SHA-1加密，结果全部转换成大写

   ```
   75149F9AF20E9186DADAC2D9CCBA70A9F87473F3
   ```


### 2. 请求报文样例

```json
{
    header: {
        appId:ee0272c4-db40-11e8-922e-28924a378ce0,
        appKey:sfzn_a8639fd95ff7f69dfef9a04d0225cf96,
        timeStamp:20181031145501987,
        sign: A790805CDAF7234B479BC0273B36EF17F9F57CAF
    },
    body: {
    	agentcode: 00000001,
        comCode: 440100
    }
}
```



### 3. 返回参数

| 字段        | 类型    | 是否必须 | 说明                                           |
| ----------- | ------- | -------- | ---------------------------------------------- |
| successFlag | Boolean | 是       | 接口处理是否成功，true成功，false失败          |
| errorCode   | String  | 否       | 当successFlag为false时有值，标识错误对应的代码 |
| message     | String  | 否       | 当successFlag为false时有值，返回错误信息       |
| data        | Object  | 是       | 业务返回数据，不同的接口返回业务数据不同       |
|             |         |          |                                                |
|             |         |          |                                                |

### 4. 返回报文样例：

```
{
    successFlag:true,
    errorCode:0000,
    message:'successed',
    data: {
    	url: 'http://www.baidu.com',
        recommendId: 1
    }
}
```



##三、接口明细

### 1.推荐商机生成接口

- 接口路径: /api/recommend

- API功能描述：推送一笔推荐投保商机，成功时返回该客户的投保url

- 请求方式：POST

- 业务参数：

  | 字段          | 类型                      | 是否必须 | 说明                                                         |
  | ------------- | ------------------------- | -------- | ------------------------------------------------------------ |
  | riskInfo      | List\<RecommendRiskInfo\> | 是       | 推荐的险种，最少1个，可传多个                                |
  | --riskCode    | String                    | 是       | 险种代码 * 如WBK、EDD等                                      |
  | --planCode    | String                    | 否       | 产品代码，可选，如有传值，则投保页面会默认选中planCode指定的产品 * 如：EDD4400040等 |
  | --sellfeerate | Integer                   | 是       | 跟单费率，百分比整数，例如0.25传25                           |
  | comCode       | String                    | 是       | 归属机构码                                                   |
  | makeCode      | String                    | 是       | 出单机构码                                                   |
  | handlerCode   | String                    | 是       | 经办人码                                                     |
  | handler1Code  | String                    | 是       | 归属业务员码                                                 |
  | operatorCode  | String                    | 是       | 操作员码                                                     |
  | sellerno      | String                    | 是       | 销售人员码                                                   |
  | sellername    | String                    | 是       | 销售人员名字                                                 |
  | agentcode     | String                    | 是       | 渠道码                                                       |
  | customId      | String                    | 是       | 客户ID（标识客户画像中的客户标识）                           |
  | customerName  | String                    | 是       | 客户姓名                                                     |
  | idType        | String                    | 是       | 证件类型：<br/> 01  --  身份证
 02  --   户口薄
 03   --  护照
 04   --  军人证件
 05   --  驾驶执照
 06   --  返乡证
 07   --  港澳身份证
 08   --  工号
 09   --  赴台通行证
 10   --  港澳通行证
 15   --  士兵证
 21   --  外国护照
 22   --  旅行证
 23   --  回乡证
 24  --   居留证件
 25   --  港澳居民来往内地通行证
 26   --  台湾居民来往内地通行证
 29   --  其他个人证件
 31  --  组织机构代码证
 32   --  工商登记证
 33   --  税务登记证
 34   --  营业执照
 99   --  其他
 37   --  统一社会信用代码 |
  | idNumber      | String                    | 是       | 证件号                                                       |
  | gender        | Number                    | 是       | 性别：1--男 2--女                                            |
  | birthDay      | String                    | 否       | 生日，转换成JSON时的格式：yyyy-MM-dd HH:mm:ss.SSS，如"1989-01-01 00:00:00.000" |
  | mobile        | String                    | 是       | 手机                                                         |
  | email         | String                    | 否       | 邮箱                                                         |
  | address       | String                    | 是       | 家庭地址（全）                                               |

- 返回参数：

  | 字段          | 类型                 | 是否必须 | 说明                                                         |
  | :------------ | -------------------- | -------- | ------------------------------------------------------------ |
  | batchId       | String               | 是       | 批量推送ID(预留，用于单链接的多险种推送)                     |
  | recommendUrls | List\<RecommendUrl\> | 是       | 推送链接，与请求的险种一一对应，每个险种会返回对应的一个链接 |
  | --url         | String               | 是       | 投保页面的URL                                                |
  | --recommendId | String               | 是       | 推荐ID                                                       |
  | --riskCode    | String               | 是       | 推荐链接对应的险种代码                                       |

- 请求报文样例

  ```json
  {
      "body": {
          "address": "北京市中南海自编133号五栋16号之6", 
          "agentcode": "000011000001", 
          "birthDay": "1955-02-01 00:00:00.000", 
          "comCode": "44130230", 
          "customerName": "张武", 
          "email": "zw@testaaaa.cc", 
          "gender": 1, 
          "handler1Code": "84444154", 
          "handlerCode": "84444154", 
          "idNumber": "440103198901015321", 
          "idType": "01", 
          "makeCode": "44130230", 
          "mobile": "13800138000", 
          "operatorCode": "09035637", 
          "riskInfo": [
              {
                  "riskCode": "WBK", 
                  "sellfeerate": 30
              }, 
              {
                  "riskCode": "EDD", 
                  "sellfeerate": 35
              }
          ], 
          "sellername": "罗佩佩", 
          "sellerno": "0100004413008000201800192", 
          "tsUserCode": "288993123"
      }, 
      "header": {
          "appId": "ee0272c4-db40-11e8-922e-28924a378ce0", 
          "appKey": "sfzn_a8639fd95ff7f69dfef9a04d0225cf96", 
          "sign": "F8ED44355929FDACC59F7EABB4659DB98D9E73B6", 
          "timeStamp": "2018-11-20 10:15:15.421"
      }
  }
  ```

- 返回报文样例

  ```json
  {
      "successFlag": true, 
      "errorCode": "0000", 
      "message": "成功", 
      "data": {
          "batchId": "58375c3b-ec6a-11e8-922e-28924a378ce0", 
          "recommendUrls": [
              {
                  "riskCode": "WBK", 
                  "url": "t.piccgd.com/yrbt/reinsurance/productInfo.do?recommendId=5838a7fb-ec6a-11e8-922e-28924a378ce0", 
                  "recommendId": "5838a7fb-ec6a-11e8-922e-28924a378ce0"
              }, 
              {
                  "riskCode": "EDD", 
                  "url": "t.piccgd.com/yrbt/reinsurance/productInfo.do?recommendId=583ae6f9-ec6a-11e8-922e-28924a378ce0", 
                  "recommendId": "583ae6f9-ec6a-11e8-922e-28924a378ce0"
              }
          ]
      }
  }
  ```


## 四、SDK及Demo

本接口提供Java版本的SDK，包括请求及返回参数的实体类、各参数常量、异常、签名工具等。

### 1. 引入接口SDK依赖

1. 添加以下maven仓库

   ```xml
   <repositories>
       <repository>
       	<id>Releases</id>
       	<url>http://dev.sinosoftgz.com:5531/nexus/content/repositories/releases</url>
       </repository>
   </repositories>
   ```

2. 加入Maven依赖

   ```xml
   <dependency>
       <groupId>com.picc.gz.sfzn</groupId>
       <artifactId>sfzn-api</artifactId>
       <version>1.0.1</version>
   </dependency>
   ```


### 2. 签名工具

使用签名工具可以直接根据BaseRequest对象生成签名：

```java
request.setHeader(requestHeader);
request.setBody(body);
String sign = SignUtil.signRequest(request, appSecret);
requestHeader.setSign(sign);
```



### 3. 转换JSON

建议使用FastJson方式将实体类转换成JSON：

```java
BaseRequest<RecommendRequest> request = new BaseRequest<>();
RequestHeader requestHeader = new RequestHeader();
RecommendRequest body = new RecommendRequest();
request.setHeader(requestHeader);
request.setBody(body);
String requestJson = JSON.toJSONString(request);
```

如使用其它JSON转换工具，请注意时间格式为："yyyy-MM-dd HH:mm:ss.SSS"



###4. 接口常量

接口中用到的常量见com.picc.gz.sfzn.api.ApiConstants

### 5. 快速Demo

#### 1. 使用apidemo

样例程序apidemo为springboot应用，启动即可运行样例代码，样例代码详见com.picc.gz.sfzn.demo.apidemo.RecommendPostTestStartRunner



####2. 接口调用样例代码

```java
OkHttpClient.Builder builder=new OkHttpClient.Builder();
OkHttpClient okHttpClient = builder.build();


BaseRequest<RecommendRequest> request = new BaseRequest<>();
RequestHeader requestHeader = new RequestHeader();
String appSecret = "A790805CDAF7234B479BC0273B36EF17F9F57CAF";
requestHeader.setAppId("ee0272c4-db40-11e8-922e-28924a378ce0");
requestHeader.setAppKey("sfzn_a8639fd95ff7f69dfef9a04d0225cf96");
requestHeader.setTimeStamp(new Date());

RecommendRequest body = new RecommendRequest();
body.setAddress("北京市中南海自编133号五栋16号之6");
body.setMobile("13800138000");
body.setIdNumber("440103198901015321");
body.setIdType(ApiConstants.IdTypes.IDCARD);

body.setBirthDay(new SimpleDateFormat("yyyy-MM-dd 00:00:00").parse("1955-02-01 00:00:00"));
body.setCustomerName("张武");
body.setEmail("zw@testaaaa.cc");
body.setGender(1);


body.setAgentcode("000011000001");
body.setMakeCode("44130230");
body.setComCode("44130230");
body.setHandler1Code("84444154");
body.setHandlerCode("84444154");

body.setOperatorCode("09035637");
body.setSellerno("0100004413008000201800192");
body.setSellername("罗佩佩");
body.setTsUserCode("288993123");

List<RecommendRiskInfo> riskInfos = new ArrayList<>();
RecommendRiskInfo r = new RecommendRiskInfo();
r.setRiskCode("WBK");
r.setSellfeerate(30);
riskInfos.add(r);
r = new RecommendRiskInfo();
r.setRiskCode("EDD");
r.setSellfeerate(35);
riskInfos.add(r);
body.setRiskInfo(riskInfos);

request.setHeader(requestHeader);
request.setBody(body);
String sign = SignUtil.signRequest(request, appSecret);
requestHeader.setSign(sign);

final MediaType JSON_TYPE = MediaType.parse(ApiConstants.HTTP_REQUEST_DEFAULT_CONTENT_TYPE
                + "; charset=" + ApiConstants.HTTP_REQUEST_DEFAULT_CHARSET);
String requestJson = JSON.toJSONString(request);
System.out.println("requestJson: " + requestJson);
RequestBody requestBody = RequestBody.create(JSON_TYPE, requestJson);



Request httpRequest = new Request.Builder()
    //                .url("http://56.50.32.188:8988/sfzn/api/recommend")
    .url("http://56.1.88.169:8088/sfzn/api/recommend")
    //                .url("http://56.1.78.83:8899/sfzn/api/recommend")
    .post(requestBody)
    //                .addHeader("Content-Type", ApiConstants.HTTP_REQUEST_DEFAULT_CONTENT_TYPE)
    .build();

try {
    Response response = okHttpClient.newCall(httpRequest).execute();
    String responseBody = response.body().string();
    log.info("responseBody-->{}", responseBody);
    if(StringUtils.isEmpty(responseBody)){
        log.info("服务器返回信息为空");
    }else {
        log.info("服务器返回的信息-->{}", responseBody);
    }

    response = okHttpClient.newCall(httpRequest).execute();
    responseBody = response.body().string();
    log.info("responseBody-->{}", responseBody);
    if(StringUtils.isEmpty(responseBody)){
        log.info("服务器返回信息为空");
    }else {
        log.info("服务器返回的信息-->{}", responseBody);
    }
} catch (Exception e) {
    e.printStackTrace();
}
```

