/*
 * Decompiled with CFR 0.152.
 */
package com.picc.gz.utils;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class AddressResolutionUtils {
    public static Map<String, String> addressResolution(String address) {
        String regex = "(?<province>[^\u7701]+\u81ea\u6cbb\u533a|.*?\u7701|.*?\u884c\u653f\u533a|.*?\u5e02)(?<city>[^\u5e02]+\u81ea\u6cbb\u5dde|.*?\u5730\u533a|.*?\u884c\u653f\u5355\u4f4d|.+\u76df|\u5e02\u8f96\u533a|.*?\u5e02|.*?\u53bf)(?<county>[^\u53bf]+\u53bf|.+\u533a|.+\u5e02|.+\u65d7|.+\u6d77\u57df|.+\u5c9b)?(?<town>[^\u533a]+\u533a|.+\u9547)?(?<village>.*)";
        Matcher m = Pattern.compile(regex).matcher(address);
        String province = null;
        String city = null;
        String county = null;
        String town = null;
        String village = null;
        LinkedHashMap<String, String> row = null;
        while (m.find()) {
            row = new LinkedHashMap<String, String>();
            province = m.group("province");
            row.put("province", province == null ? "" : province.trim());
            city = m.group("city");
            row.put("city", city == null ? "" : city.trim());
            county = m.group("county");
            row.put("county", county == null ? "" : county.trim());
            town = m.group("town");
            row.put("town", town == null ? "" : town.trim());
            village = m.group("village");
            row.put("village", village == null ? "" : village.trim());
        }
        return row;
    }

    public static void main(String[] args) {
        System.out.println(AddressResolutionUtils.addressResolution("\u6c55\u5934\u5e02"));
    }
}

