/*
 * Decompiled with CFR 0.152.
 */
package com.picc.gz.utils;

import java.net.Inet4Address;
import java.util.Enumeration;
import javax.servlet.http.HttpServletRequest;
import sun.net.util.IPAddressUtil;

public class IPUtils {
    public static String getIP(HttpServletRequest req) {
        if (!IPUtils.internalIp(req.getRemoteAddr())) {
            return req.getRemoteAddr();
        }
        Enumeration heads = req.getHeaderNames();
        while (heads.hasMoreElements()) {
            String head = (String)heads.nextElement();
            if (!"X-Forwarded-For".toLowerCase().equals(head.trim()) && !"X-Real-IP".toLowerCase().equals(head.trim()) || IPUtils.internalIp(req.getHeader(head))) continue;
            return req.getHeader(head);
        }
        return req.getRemoteAddr();
    }

    public static boolean internalIp(String ip) {
        byte[] addr = IPAddressUtil.textToNumericFormatV4(ip);
        return IPUtils.internalIp(addr);
    }

    public static boolean internalIp(byte[] addr) {
        byte b0 = addr[0];
        byte b1 = addr[1];
        int SECTION_1 = 10;
        int SECTION_2 = -84;
        int SECTION_3 = 16;
        int SECTION_4 = 31;
        int SECTION_5 = -64;
        int SECTION_6 = -88;
        switch (b0) {
            case 10: {
                return true;
            }
            case -84: {
                if (b1 >= 16 && b1 <= 31) {
                    return true;
                }
            }
            case -64: {
                switch (b1) {
                    case -88: {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    public static String getClientIpAdres(HttpServletRequest request, String alternateServerAddrHeaderName, String alternateLocalAddrHeaderName, boolean useServerHostAddress) {
        String clientIpAddress = request != null ? request.getRemoteAddr() : null;
        try {
            if (request != null && alternateLocalAddrHeaderName != null && !alternateLocalAddrHeaderName.isEmpty()) {
                clientIpAddress = request.getHeader(alternateLocalAddrHeaderName) != null ? request.getHeader(alternateLocalAddrHeaderName) : request.getRemoteAddr();
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return clientIpAddress;
    }

    public static String getServiceIpAdres(HttpServletRequest request, String alternateServerAddrHeaderName, String alternateLocalAddrHeaderName, boolean useServerHostAddress) {
        String serverIpAddress = request != null ? request.getLocalAddr() : null;
        try {
            if (request != null) {
                if (useServerHostAddress) {
                    serverIpAddress = Inet4Address.getLocalHost().getHostAddress();
                } else if (alternateServerAddrHeaderName != null && !alternateServerAddrHeaderName.isEmpty()) {
                    serverIpAddress = request.getHeader(alternateServerAddrHeaderName) != null ? request.getHeader(alternateServerAddrHeaderName) : request.getLocalAddr();
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return serverIpAddress;
    }
}

