/*
 * Decompiled with CFR 0.152.
 */
package com.picc.gz.utils;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.springframework.util.StringUtils;

public abstract class RegularUtils {
    private static Pattern EAMIL_PATTERN = Pattern.compile("([a-zA-Z0-9._-])+@([a-zA-Z0-9-])+(\\.+([\\w]{2,6})){1,}");
    private static Pattern PHONE_PATTERN = Pattern.compile("^1\\d{10}$");
    private static Pattern NUMBER_PATTERN = Pattern.compile("^[-\\+]?[\\d]*$");

    public static boolean isEmail(String email) {
        if (null == email) {
            return false;
        }
        Matcher m = EAMIL_PATTERN.matcher(email);
        return m.matches();
    }

    public static boolean isPhone(String phoneNum) {
        if (null == phoneNum) {
            return false;
        }
        Matcher m = PHONE_PATTERN.matcher(phoneNum);
        return m.matches();
    }

    public static boolean isPassword(String password) {
        Boolean flag = false;
        if (null == password || "".equals(password)) {
            return flag;
        }
        char p = password.charAt(0);
        if (password.length() < 6 || password.length() > 16) {
            return flag;
        }
        String az = "abcdefghijklmnopqrstuvwxyzAQWERTYUIOPSDFGHJKLZXCVBNM";
        if (az.indexOf(p) != -1) {
            for (int i = 0; i < password.length(); ++i) {
                String num = "1234567890";
                char con = password.charAt(i);
                if (num.indexOf(con) == -1) continue;
                flag = true;
                break;
            }
        }
        return flag;
    }

    public static boolean isNumbers(String numbers) {
        return NUMBER_PATTERN.matcher(numbers).matches();
    }

    public static boolean isUserNme(String userName) {
        if (StringUtils.isEmpty((Object)userName)) {
            return false;
        }
        char[] chars = userName.toCharArray();
        if (5 > chars.length || chars.length > 30) {
            return false;
        }
        if (userName.indexOf("_") == -1) {
            return false;
        }
        int isIncludeNumber = 0;
        int isIncludeLetter = 0;
        int underlineNumber = 0;
        for (int i = 0; i < chars.length; ++i) {
            if (chars[i] == '_') {
                ++underlineNumber;
            }
            if ('0' <= chars[i] && chars[i] <= '9') {
                ++isIncludeNumber;
            }
            if (('A' > chars[i] || chars[i] > 'Z') && ('a' > chars[i] || chars[i] > 'z')) continue;
            ++isIncludeLetter;
        }
        if (underlineNumber == chars.length) {
            return false;
        }
        if (isIncludeNumber < 1) {
            return false;
        }
        return isIncludeLetter >= true;
    }
}

