/*
 * Decompiled with CFR 0.152.
 */
package com.picc.gz.utils;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Calendar;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public abstract class TimeUtils {
    private static final Logger logger = LoggerFactory.getLogger(TimeUtils.class);

    public static Date strToDate(String strDate) {
        Date date = null;
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        try {
            date = sdf.parse(strDate);
        }
        catch (ParseException e) {
            logger.error("\u65e5\u671f\u8f6c\u6362\u5f02\u5e38\u4fe1\u606f\uff1a{}", (Throwable)e);
        }
        return date;
    }

    public static String dateToStr(Date date) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return sdf.format(date);
    }

    public static Date getCurrentDate() {
        return Date.from(Instant.now());
    }

    public static String getCurrentDateStr() {
        LocalDate date = LocalDate.now();
        return date.format(DateTimeFormatter.ofPattern("yyyy-MM-dd"));
    }

    public static String getCurrDateTimeStr() {
        LocalDateTime dateTime = LocalDateTime.now();
        return dateTime.format(DateTimeFormatter.ofPattern("uuuu-MM-d HH:mm:ss"));
    }

    public static long getDistanceMills() {
        Calendar cal = Calendar.getInstance();
        cal.set(10, 12);
        cal.set(13, 0);
        cal.set(12, 0);
        cal.set(14, 0);
        cal.add(6, 0);
        return cal.getTimeInMillis() - System.currentTimeMillis();
    }

    public static long getDatePoor(Date startDate, Date endDate, String type) {
        long nd = 86400000L;
        long nh = 3600000L;
        long nm = 60000L;
        long ns = 1000L;
        long diff = endDate.getTime() - startDate.getTime();
        long day = diff / nd;
        long hour = diff % nd / nh;
        long min = diff % nd % nh / nm;
        long sec = diff % nd % nh % nm / ns;
        if ("d".equals(type)) {
            return day;
        }
        if ("h".equals(type)) {
            return hour;
        }
        if ("m".equals(type)) {
            return min;
        }
        if ("s".equals(type)) {
            return sec;
        }
        return -1L;
    }

    public static boolean isSameYear(String startDate, String endDate) throws ParseException {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy/MM/dd");
        Date date1 = sdf.parse(startDate);
        Date date2 = sdf.parse(endDate);
        Calendar calendar1 = Calendar.getInstance();
        calendar1.setTime(date1);
        Calendar calendar2 = Calendar.getInstance();
        calendar2.setTime(date2);
        int year1 = calendar1.get(1);
        int year2 = calendar2.get(1);
        return year1 == year2;
    }

    public static boolean isSameYear(String startDate, String endDate, String format) {
        if (StringUtils.isEmpty((Object)format)) {
            format = "yyyy/MM/dd";
        }
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        Date date1 = null;
        Date date2 = null;
        try {
            date1 = sdf.parse(startDate);
            date2 = sdf.parse(endDate);
        }
        catch (ParseException e) {
            logger.error("\u65e5\u671f\u8f6c\u6362\u5f02\u5e38\u4fe1\u606f\uff1a{}", (Throwable)e);
            return false;
        }
        Calendar calendar1 = Calendar.getInstance();
        calendar1.setTime(date1);
        Calendar calendar2 = Calendar.getInstance();
        calendar2.setTime(date2);
        int year1 = calendar1.get(1);
        int year2 = calendar2.get(1);
        return year1 == year2;
    }

    public static long dateInterval(String startDateStr, String endDateStr) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy/MM/dd");
        Date date1 = null;
        Date date2 = null;
        long startDateLong = 0L;
        long endDateLong = 0L;
        try {
            date1 = sdf.parse(startDateStr);
            date2 = sdf.parse(endDateStr);
            startDateLong = date1.getTime();
            endDateLong = date2.getTime();
        }
        catch (ParseException e) {
            logger.error("\u65e5\u671f\u8f6c\u6362\u5f02\u5e38\u4fe1\u606f\uff1a{}", (Throwable)e);
        }
        return (startDateLong - endDateLong) / 86400000L;
    }

    public static boolean startDateIsGreaterEndDate(String startDateStr, String endDateStr) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy/MM/dd");
        Date date1 = null;
        Date date2 = null;
        long startDateLong = 0L;
        long endDateLong = 0L;
        try {
            date1 = sdf.parse(startDateStr);
            date2 = sdf.parse(endDateStr);
            startDateLong = date1.getTime();
            endDateLong = date2.getTime();
        }
        catch (ParseException e) {
            logger.error("\u65e5\u671f\u8f6c\u6362\u5f02\u5e38\u4fe1\u606f\uff1a{}", (Throwable)e);
        }
        return endDateLong - startDateLong >= 0L;
    }
}

