/*
 * Decompiled with CFR 0.152.
 */
package com.picc.gz.utils.config;

import com.picc.gz.utils.jdbc.JdbcTemplatePlus;
import javax.sql.DataSource;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.jdbc.DataSourceAutoConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;

@Configuration
@ConditionalOnClass(value={DataSource.class, JdbcTemplatePlus.class})
@AutoConfigureAfter(value={DataSourceAutoConfiguration.class})
public class JdbcTemplatePlusAutoConfig {
    private final DataSource dataSource;

    public JdbcTemplatePlusAutoConfig(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    @Bean
    @Primary
    @ConditionalOnMissingBean(value={JdbcTemplatePlus.class})
    public JdbcTemplatePlus jdbcTemplatePlus() {
        return new JdbcTemplatePlus(this.dataSource);
    }
}

