/*
 * Decompiled with CFR 0.152.
 */
package com.picc.gz.utils.data;

import com.picc.gz.utils.io.DownloadFileInfoVO;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import javax.servlet.http.HttpServletRequest;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public class SpringMvcUtils {
    public static ResponseEntity<Resource> downloadResponse(DownloadFileInfoVO fileInfo) throws IOException {
        File file = fileInfo.getFile();
        String fileName = fileInfo.getFileName();
        return SpringMvcUtils.downloadResponse(fileName, (Resource)new FileSystemResource(file), file.length());
    }

    public static ResponseEntity<Resource> downloadResponse(String fileName, byte[] fileBytes) throws IOException {
        return SpringMvcUtils.downloadResponse(fileName, (Resource)new ByteArrayResource(fileBytes), Long.valueOf(fileBytes.length));
    }

    public static ResponseEntity<Resource> downloadResponse(String fileName, Resource resource, Long contentLength) throws IOException {
        HttpServletRequest request = ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest();
        String header = request.getHeader("User-Agent").toUpperCase();
        HttpStatus status = HttpStatus.CREATED;
        try {
            if (header.contains("MSIE") || header.contains("TRIDENT") || header.contains("EDGE")) {
                fileName = URLEncoder.encode(fileName, "UTF-8");
                fileName = fileName.replace("+", "%20");
                status = HttpStatus.OK;
            } else {
                fileName = new String(fileName.getBytes("UTF-8"), "ISO8859-1");
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_OCTET_STREAM);
        headers.setContentDispositionFormData("attachment", fileName);
        headers.setContentLength(contentLength == null ? resource.contentLength() : contentLength.longValue());
        return new ResponseEntity((Object)resource, (MultiValueMap)headers, status);
    }
}

