/*
 * Decompiled with CFR 0.152.
 */
package ins.framework.validate.passwordvalidate;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PasswordValidate {
    private static final String BEGININDEX = PasswordValidate.readValue("CommonWords.properties", "BEGININDEX");
    private static final String ENDINDEX = PasswordValidate.readValue("CommonWords.properties", "ENDINDEX");
    public static final String CommonPass = PasswordValidate.readValue("CommonWords.properties", "CommonPass");
    public static final String CommonPassLength = PasswordValidate.readValue("CommonWords.properties", "CommonPassLength");
    public static final String ManagerPasswordBeginIndex = PasswordValidate.readValue("CommonWords.properties", "ManagerPasswordBeginIndex");

    public static String validPassWord(String password, String oldpassword, Boolean isManager) {
        if (PasswordValidate.isEmpty(password)) {
            return "\u5bc6\u7801\u4e0d\u53ef\u4e3a\u7a7a";
        }
        if (isManager.booleanValue() && !PasswordValidate.passWordLength(password, true)) {
            return "\u7ba1\u7406\u5458\u5bc6\u7801\u957f\u5ea6\u5e94\u4e3a12-20\uff0c\u5e94\u81f3\u5c11\u4f7f\u7528\u6570\u5b57\uff0c\u5927\u5199\u5b57\u6bcd\uff0c\u5c0f\u5199\u5b57\u6bcd\uff0c\u7279\u6b8a\u7b26\u53f7\u4e2d\u7684\u4e24\u79cd";
        }
        if (!PasswordValidate.isEmpty(oldpassword)) {
            if (PasswordValidate.isLoop(password, oldpassword)) {
                return "\u65b0\u5bc6\u7801\u4e0d\u80fd\u662f\u65e7\u5bc6\u7801\u7684\u56de\u6587";
            }
            if (password.toLowerCase().equals(oldpassword.toLowerCase())) {
                return "\u65b0\u5bc6\u7801\u4e0d\u80fd\u662f\u65e7\u5bc6\u7801\u6539\u4e86\u5927\u5c0f\u5199\u6216\u8005\u524d\u540e\u5bc6\u7801\u4e00\u81f4";
            }
            if (PasswordValidate.isCircle(password, oldpassword)) {
                return "\u65b0\u5bc6\u7801\u4e0d\u80fd\u662f\u65e7\u5bc6\u7801\u7684\u4e00\u4e2a\u5faa\u73af";
            }
            if (PasswordValidate.isEqual(password, oldpassword, 4)) {
                return "\u4e0d\u80fd\u6709\u8fde\u7eed\u76844\u4f4d\u91cd\u590d";
            }
        }
        return PasswordValidate.validPassWord(password);
    }

    public static String validPassWord(String password) {
        if (PasswordValidate.isEmpty(password)) {
            return "\u5bc6\u7801\u4e0d\u53ef\u4e3a\u7a7a";
        }
        if (!PasswordValidate.passWordLength(password, false)) {
            return "\u5bc6\u7801\u957f\u5ea6\u4e3a8-20\uff0c\u5e94\u81f3\u5c11\u4f7f\u7528\u6570\u5b57\uff0c\u5927\u5199\u5b57\u6bcd\uff0c\u5c0f\u5199\u5b57\u6bcd\uff0c\u7279\u6b8a\u7b26\u53f7\u4e2d\u7684\u4e24\u79cd";
        }
        if (PasswordValidate.isSameChar(password)) {
            return "\u5bc6\u7801\u4e0d\u53ef\u4e3a\u540c\u4e00\u4e2a\u5b57\u7b26\u7684\u91cd\u590d\u5e8f\u5217\uff0c\u8bf7\u91cd\u65b0\u8bbe\u5b9a";
        }
        if (PasswordValidate.isRepeatChar(password)) {
            return "\u5bc6\u7801\u4e2d\u540c\u4e00\u4e2a\u5b57\u7b26\u4e0d\u53ef\u4ee5\u91cd\u590d\u51fa\u73b0\u4e09\u6b21\u6216\u4ee5\u4e0a\uff0c\u5efa\u8bae\u4fee\u6539";
        }
        if (PasswordValidate.isOrderList(password)) {
            return "\u5bc6\u7801\u4e0d\u53ef\u4ee5\u4e3a\u9012\u589e\u6570\u5217";
        }
        if (PasswordValidate.isDecreasing(password)) {
            return "\u5bc6\u7801\u4e0d\u53ef\u4ee5\u4e3a\u9012\u51cf\u6570\u5217";
        }
        if (PasswordValidate.isSequence(password)) {
            return "\u5bc6\u7801\u4e2d\u4e0d\u53ef\u4ee5\u6709\u8fde\u7eed\u7684\u6570\u5217\uff0c\u5982123,135,246,654\u7b49\u5f62\u5f0f";
        }
        if (PasswordValidate.isFourInRow(password)) {
            return "\u5bc6\u7801\u4e2d\u4e0d\u53ef\u4ee5\u6709\u591a\u4e2a\u8fde\u7eed\u5b57\u6bcd,\u5982abcd,dcba,1234asddjo\u62164321asddjo\u7b49\u5f62\u5f0f\uff0c\u8bf7\u91cd\u65b0\u8bbe\u5b9a";
        }
        if (!PasswordValidate.isKeyBoardList(password)) {
            return "\u5bc6\u7801\u4e2d\u4e0d\u53ef\u4ee5\u6709\u7279\u6b8a\u5e8f\u5217\uff0c\u5982qwer,asdf,zxcv\u7b49\uff0c\u8bf7\u91cd\u65b0\u8bbe\u5b9a";
        }
        if (!PasswordValidate.isPassType(password)) {
            return "\u5bc6\u7801\u4e0d\u7b26\u5408\u89c4\u8303\uff0c\u5bc6\u7801\u4e3a\u6570\u5b57\uff0c\u5927\u5c0f\u5199\u5b57\u7b26\uff0c\u7279\u6b8a\u7b26\u53f7\u4e2d\u81f3\u5c11\u4e24\u79cd";
        }
        if (PasswordValidate.isContainStrings(password)) {
            return "\u5bc6\u7801\u4e2d\u4e0d\u53ef\u4ee5\u5305\u542b\u5173\u952e\u5b57PICC\uff0c\u4e0d\u533a\u5206\u5927\u5c0f\u5199";
        }
        if (PasswordValidate.isCommonList(password)) {
            return "\u5bc6\u7801\u4e2d\u4e0d\u80fd\u6709\u5e38\u7528\u8bcd\uff0c\u5982admin\uff0cpicc\u7b49\uff0c\u4e0d\u533a\u5206\u5927\u5c0f\u5199";
        }
        return "1";
    }

    public static boolean isEmpty(String str) {
        return str == null || str.trim().equals("");
    }

    public static boolean passWordLength(String str, Boolean isManager) {
        String pass_length = "";
        pass_length = isManager != false ? "^[\\d\\D]{" + ManagerPasswordBeginIndex + "," + ENDINDEX + "}$" : "^[\\d\\D]{" + BEGININDEX + "," + ENDINDEX + "}$";
        return str.matches(pass_length);
    }

    public static boolean isSameChar(String str) {
        boolean flag = true;
        char str1 = str.charAt(0);
        for (int i = 0; i < str.length(); ++i) {
            if (str1 != str.charAt(i)) {
                flag = false;
                break;
            }
            flag = true;
        }
        return flag;
    }

    public static boolean isOrderList(String str) {
        int i;
        boolean flag1 = true;
        boolean isNumeric = true;
        for (i = 0; i < str.length(); ++i) {
            if (Character.isDigit(str.charAt(i))) continue;
            isNumeric = false;
            flag1 = false;
            return flag1;
        }
        if (isNumeric) {
            for (i = 0; i < str.length(); ++i) {
                int num_;
                int num;
                if (i <= 0 || (num = Integer.parseInt(str.charAt(i) + "")) == (num_ = Integer.parseInt(str.charAt(i - 1) + "") + 1)) continue;
                flag1 = false;
                return flag1;
            }
        }
        return flag1;
    }

    public static boolean isDecreasing(String str) {
        int i;
        boolean flag2 = true;
        boolean isNumeric2 = true;
        for (i = 0; i < str.length(); ++i) {
            if (Character.isDigit(str.charAt(i))) continue;
            isNumeric2 = false;
            flag2 = false;
            return flag2;
        }
        if (isNumeric2) {
            for (i = 0; i < str.length(); ++i) {
                int num_;
                int num;
                if (i <= 0 || (num = Integer.parseInt(str.charAt(i) + "")) == (num_ = Integer.parseInt(str.charAt(i - 1) + "") - 1)) continue;
                flag2 = false;
                return flag2;
            }
        }
        return flag2;
    }

    public static boolean isFourInRow(String str) {
        boolean flag11;
        String[] str11 = str.split("");
        int cout = 0;
        for (int i = 0; i < str11.length - 1; ++i) {
            if (str11[i].hashCode() != str11[i + 1].hashCode() && (str11[i + 1].hashCode() - str11[i].hashCode() == 1 || str11[i].hashCode() - str11[i + 1].hashCode() == 1)) {
                flag11 = true;
                ++cout;
            } else {
                flag11 = false;
                cout = 0;
            }
            if (cout > 2) break;
        }
        if (cout > 2) {
            flag11 = true;
            return true;
        }
        flag11 = false;
        return false;
    }

    public static boolean isPassType(String str) {
        String regFirst = "^[0-9a-zA-Z_\\W]{8,20}$";
        String regSecond = "^(?![0-9]+$)(?![a-z]+$)(?![A-Z]+$)(?![\\W]+$)[0-9a-zA-Z\\W_]+$";
        if (str.matches(regFirst)) {
            if (str.matches(regSecond)) {
                String regTwo = "^([0-9a-z_]+)|([0-9A-Z_]+)|([0-9_\\W]+)|([a-zA-Z_]+)([a-z_\\W]+)|([A-Z_\\W]+)$";
                String regThree = "^([0-9a-zA-Z_]+)|([0-9a-z_\\W]+)|([0-9A-Z_\\W]+)|([a-zA-Z_\\W]+)$";
                String regAll = "^[0-9a-zA-Z_\\W]+$";
                if (str.matches(regTwo)) {
                    return true;
                }
                if (str.matches(regThree)) {
                    return true;
                }
                if (str.matches(regAll)) {
                    return true;
                }
            } else {
                return false;
            }
        }
        return false;
    }

    public static boolean isKeyBoardList(String str) {
        PasswordValidate.isFirstList(str);
        PasswordValidate.isSecondList(str);
        PasswordValidate.isThirdList(str);
        String first = PasswordValidate.isFirstList(str);
        String second = PasswordValidate.isSecondList(str);
        String third = PasswordValidate.isThirdList(str);
        return first.equals("1") && second.equals("1") && third.equals("1");
    }

    public static String isFirstList(String str) {
        int beginIndex;
        String[] strList = new String[]{"q", "w", "e", "r", "t", "y", "u", "i", "o", "p", "[", "]"};
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < strList.length; ++i) {
            sb.append(strList[i]);
        }
        String str_1 = sb.toString();
        for (int i = 0; i < str_1.length() && (beginIndex = i) <= str_1.length() - 4; ++i) {
            int endIndex = i + 4;
            String str_11 = str_1.substring(beginIndex, endIndex);
            boolean flag1 = str.contains(str_11);
            boolean flag = flag1;
            if (!flag) continue;
            return "\u5305\u542b\u7ed9\u5b9a\u7684\u5b57\u7b26\u4e32\u5e8f\u5217\u7684\u8fde\u7eed\u5b50\u5e8f\u5217";
        }
        return "1";
    }

    public static String isSecondList(String str) {
        int beginIndex;
        String[] str1 = new String[]{"a", "s", "d", "f", "g", "h", "j", "k", "l", ";", ",", "\\"};
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < str1.length; ++i) {
            sb.append(str1[i]);
        }
        String str_1 = sb.toString();
        for (int i = 0; i < str_1.length() && (beginIndex = i) <= str_1.length() - 4; ++i) {
            int endIndex = i + 4;
            String str_11 = str_1.substring(beginIndex, endIndex);
            boolean flag1 = str.contains(str_11);
            boolean flag = flag1;
            if (!flag) continue;
            return "\u5305\u542b\u7ed9\u5b9a\u7684\u5b57\u7b26\u4e32\u5e8f\u5217\u7684\u8fde\u7eed\u5b50\u5e8f\u5217";
        }
        return "1";
    }

    public static String isThirdList(String str) {
        int beginIndex;
        String[] str2 = new String[]{"z", "x", "c", "v", "b", "n", "m", ",", ".", "/"};
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < str2.length; ++i) {
            sb.append(str2[i]);
        }
        String str_1 = sb.toString();
        for (int i = 0; i < str_1.length() && (beginIndex = i) <= str_1.length() - 4; ++i) {
            int endIndex = i + 4;
            String str_11 = str_1.substring(beginIndex, endIndex);
            boolean flag1 = str.contains(str_11);
            boolean flag = flag1;
            if (!flag) continue;
            return "\u5305\u542b\u7ed9\u5b9a\u7684\u5b57\u7b26\u4e32\u5e8f\u5217\u7684\u8fde\u7eed\u5b50\u5e8f\u5217";
        }
        return "1";
    }

    public static boolean isCommonList(String password) {
        ArrayList<String> commonList = new ArrayList<String>();
        boolean flag = false;
        commonList.add("admin");
        commonList.add("ADMIN");
        commonList.add("picc");
        commonList.add("PICC");
        commonList.add("user");
        commonList.add("USER");
        commonList.add("Picc");
        commonList.add("epicc");
        for (int i = 0; i < commonList.size() - 1; ++i) {
            flag = password.toLowerCase().contains(((String)commonList.get(i)).toLowerCase());
            if (!flag) continue;
            return flag;
        }
        return flag;
    }

    public static boolean isRepeatChar(String str) {
        boolean flag = false;
        int count = 0;
        for (int i = 0; i < str.length() - 1; ++i) {
            if (str.charAt(i) == str.charAt(i + 1)) {
                char a = str.charAt(i);
                String strRepeat = str.substring(i);
                for (int j = 0; j < strRepeat.length() - 1; ++j) {
                    if (strRepeat.charAt(j) != a) continue;
                    System.out.println(++count);
                    if (count != 3) continue;
                    flag = true;
                    return flag;
                }
                continue;
            }
            return flag;
        }
        return false;
    }

    public static boolean isContainStrings(String pass) {
        boolean flag = false;
        char b = CommonPass.charAt(0);
        String str = pass.toLowerCase();
        String c = "";
        int subLength = Integer.parseInt(CommonPassLength);
        for (int i = 0; i < str.length() - 1; ++i) {
            if (str.charAt(i) != b) continue;
            c = i + subLength <= str.length() ? str.substring(i, i + subLength) : str.substring(i);
            if (c.equalsIgnoreCase(CommonPass)) {
                flag = true;
                return flag;
            }
            flag = false;
            return flag;
        }
        return flag;
    }

    public static boolean isSequence(String pass) {
        Pattern p = Pattern.compile("\\d{3,}");
        Matcher m = p.matcher(pass);
        int i = 0;
        boolean flag = false;
        while (m.find()) {
            System.out.println("\u51fa\u73b0\u7684\u4e09\u4e2a\u4ee5\u4e0a\u8fde\u7eed\u6570\u5b57\u7247\u6bb5\u6570\u4f4d\uff1a\u7b2c" + ++i + "\u6bb5");
            System.out.println(m.group());
            String str = m.group();
            for (int j = 0; j < str.length() - 2; ++j) {
                int num2;
                int num = Integer.parseInt(str.charAt(j) + "");
                int num1 = Integer.parseInt(str.charAt(j + 1) + "");
                if (num1 - num != (num2 = Integer.parseInt(str.charAt(j + 2) + "")) - num1) continue;
                flag = true;
                return flag;
            }
        }
        return flag;
    }

    public static boolean isLoop(String password, String oldpassword) {
        StringBuffer sb = new StringBuffer(password);
        sb.reverse();
        String str2 = sb.toString();
        return oldpassword.equals(str2);
    }

    public static boolean isEqual(String password, String oldpassword, int length) {
        StringBuffer sb = new StringBuffer(password);
        int len = sb.length();
        int size = (len - len % length) / length;
        boolean flag = false;
        for (int i = 0; i < size; ++i) {
            String str = sb.substring(i * length, (i + 1) * length);
            if (!oldpassword.contains(str)) continue;
            flag = true;
            break;
        }
        return flag;
    }

    public static boolean isCircle(String password, String oldpassword) {
        boolean flag = false;
        if (password.length() == oldpassword.length()) {
            char[] temp = new char[password.length()];
            temp = password.toCharArray();
            for (int i = 0; i <= temp.length; ++i) {
                for (int j = 0; j < temp.length - 1; ++j) {
                    char c = temp[j];
                    temp[j] = temp[j + 1];
                    temp[j + 1] = c;
                }
                if (!String.valueOf(temp).equals(oldpassword)) continue;
                flag = true;
                break;
            }
        }
        return flag;
    }

    public static String readValue(String filePath, String key) {
        Properties props = new Properties();
        try {
            BufferedInputStream in = new BufferedInputStream(new FileInputStream(filePath));
            props.load(in);
            String value = props.getProperty(key);
            System.out.println(key + "=" + value);
            return value;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void writeProperties(String filePath, String parameterName, String parameterValue) {
        Properties prop = new Properties();
        try {
            FileInputStream fis = new FileInputStream(filePath);
            prop.load(fis);
            FileOutputStream fos = new FileOutputStream(filePath);
            prop.setProperty(parameterName, parameterValue);
            prop.store(fos, "Update '" + parameterName + "' value");
        }
        catch (IOException e) {
            System.err.println("Visit " + filePath + " for updating " + parameterName + " value error");
        }
    }

    public static void main(String[] args) {
        String result = PasswordValidate.validPassWord("mg7h3_jd3dfk", "mg5hdfg694", false);
        if (!result.equals("1")) {
            throw new IllegalArgumentException(result);
        }
        System.out.println(result);
    }
}

