/*
 * Decompiled with CFR 0.152.
 */
package microsoft.exchange.webservices.data.core;

import microsoft.exchange.webservices.data.core.EwsServiceXmlReader;
import microsoft.exchange.webservices.data.core.EwsUtilities;

public final class ExchangeServerInfo {
    private int majorVersion;
    private int minorVersion;
    private int majorBuildNumber;
    private int minorBuildNumber;
    private String versionString;

    public static ExchangeServerInfo parse(EwsServiceXmlReader reader) throws Exception {
        EwsUtilities.ewsAssert(reader.hasAttributes(), "ExchangeServerVersion.Parse", "Current element doesn't have attribute");
        ExchangeServerInfo info = new ExchangeServerInfo();
        info.majorVersion = reader.readAttributeValue(Integer.class, "MajorVersion");
        info.minorVersion = reader.readAttributeValue(Integer.class, "MinorVersion");
        info.majorBuildNumber = reader.readAttributeValue(Integer.class, "MajorBuildNumber");
        info.minorBuildNumber = reader.readAttributeValue(Integer.class, "MinorBuildNumber");
        info.versionString = reader.readAttributeValue("Version");
        return info;
    }

    public int getMajorVersion() {
        return this.majorVersion;
    }

    public void setMajorVersion(int majorVersion) {
        this.majorVersion = majorVersion;
    }

    public int getMinorVersion() {
        return this.minorVersion;
    }

    public void setMinorVersion(int minorVersion) {
        this.minorVersion = minorVersion;
    }

    public int getMajorBuildNumber() {
        return this.majorBuildNumber;
    }

    public void setMajorBuildNumber(int majorBuildNumber) {
        this.majorBuildNumber = majorBuildNumber;
    }

    public int getMinorBuildNumber() {
        return this.minorBuildNumber;
    }

    public void setMinorBuildNumber(int minorBuildNumber) {
        this.minorBuildNumber = minorBuildNumber;
    }

    public String getVersionString() {
        return this.versionString;
    }

    public void setVersionString(String versionString) {
        this.versionString = versionString;
    }

    public String toString() {
        return String.format("%d,%2d,%4d,%3d", this.majorVersion, this.minorVersion, this.majorBuildNumber, this.minorBuildNumber);
    }
}

