/*
 * Decompiled with CFR 0.152.
 */
package microsoft.exchange.webservices.data.core;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import microsoft.exchange.webservices.data.ISelfValidate;
import microsoft.exchange.webservices.data.core.EwsServiceXmlReader;
import microsoft.exchange.webservices.data.core.EwsServiceXmlWriter;
import microsoft.exchange.webservices.data.core.EwsUtilities;
import microsoft.exchange.webservices.data.core.ICustomXmlUpdateSerializer;
import microsoft.exchange.webservices.data.core.PropertySet;
import microsoft.exchange.webservices.data.core.enumeration.misc.XmlNamespace;
import microsoft.exchange.webservices.data.core.enumeration.property.BasePropertySet;
import microsoft.exchange.webservices.data.core.enumeration.property.PropertyDefinitionFlags;
import microsoft.exchange.webservices.data.core.exception.misc.ArgumentException;
import microsoft.exchange.webservices.data.core.exception.service.local.ServiceLocalException;
import microsoft.exchange.webservices.data.core.exception.service.local.ServiceObjectPropertyException;
import microsoft.exchange.webservices.data.core.exception.service.local.ServiceVersionException;
import microsoft.exchange.webservices.data.core.service.ServiceObject;
import microsoft.exchange.webservices.data.core.service.item.Item;
import microsoft.exchange.webservices.data.misc.OutParam;
import microsoft.exchange.webservices.data.property.complex.ComplexProperty;
import microsoft.exchange.webservices.data.property.complex.IComplexPropertyChanged;
import microsoft.exchange.webservices.data.property.complex.IComplexPropertyChangedDelegate;
import microsoft.exchange.webservices.data.property.complex.IOwnedProperty;
import microsoft.exchange.webservices.data.property.definition.ComplexPropertyDefinitionBase;
import microsoft.exchange.webservices.data.property.definition.PropertyDefinition;

public class PropertyBag
implements IComplexPropertyChanged,
IComplexPropertyChangedDelegate {
    private ServiceObject owner;
    private boolean isDirty;
    private boolean loading;
    private boolean onlySummaryPropertiesRequested;
    private List<PropertyDefinition> loadedProperties = new ArrayList<PropertyDefinition>();
    private Map<PropertyDefinition, Object> properties = new HashMap<PropertyDefinition, Object>();
    private Map<PropertyDefinition, Object> deletedProperties = new HashMap<PropertyDefinition, Object>();
    private List<PropertyDefinition> modifiedProperties = new ArrayList<PropertyDefinition>();
    private List<PropertyDefinition> addedProperties = new ArrayList<PropertyDefinition>();
    private PropertySet requestedPropertySet;

    public PropertyBag(ServiceObject owner) {
        EwsUtilities.ewsAssert(owner != null, "PropertyBag.ctor", "owner is null");
        this.owner = owner;
    }

    public Map<PropertyDefinition, Object> getProperties() {
        return this.properties;
    }

    public ServiceObject getOwner() {
        return this.owner;
    }

    public boolean getIsDirty() {
        int changes = this.modifiedProperties.size() + this.deletedProperties.size() + this.addedProperties.size();
        return changes > 0 || this.isDirty;
    }

    protected static void addToChangeList(PropertyDefinition propertyDefinition, List<PropertyDefinition> changeList) {
        if (!changeList.contains(propertyDefinition)) {
            changeList.add(propertyDefinition);
        }
    }

    public boolean isPropertyLoaded(PropertyDefinition propertyDefinition) {
        if (this.loadedProperties.contains(propertyDefinition)) {
            return true;
        }
        return this.isRequestedProperty(propertyDefinition);
    }

    private boolean isRequestedProperty(PropertyDefinition propertyDefinition) {
        if (this.requestedPropertySet == null) {
            return false;
        }
        if (this.requestedPropertySet.getBasePropertySet() == BasePropertySet.FirstClassProperties) {
            List<PropertyDefinition> firstClassProps = this.onlySummaryPropertiesRequested ? this.getOwner().getSchema().getFirstClassSummaryProperties() : this.getOwner().getSchema().getFirstClassProperties();
            return firstClassProps.contains(propertyDefinition) || this.requestedPropertySet.contains(propertyDefinition);
        }
        return this.requestedPropertySet.contains(propertyDefinition);
    }

    public boolean isPropertyUpdated(PropertyDefinition propertyDefinition) {
        return this.modifiedProperties.contains(propertyDefinition) || this.addedProperties.contains(propertyDefinition);
    }

    protected boolean tryGetProperty(PropertyDefinition propertyDefinition, OutParam<Object> propertyValueOutParam) {
        OutParam<ServiceLocalException> serviceExceptionOutParam = new OutParam<ServiceLocalException>();
        propertyValueOutParam.setParam(this.getPropertyValueOrException(propertyDefinition, serviceExceptionOutParam));
        return serviceExceptionOutParam.getParam() == null;
    }

    public <T> boolean tryGetPropertyType(Class<T> cls, PropertyDefinition propertyDefinition, OutParam<T> propertyValue) throws ArgumentException {
        if (!cls.isAssignableFrom(propertyDefinition.getType())) {
            String errorMessage = String.format("Property definition type '%s' and type parameter '%s' aren't compatible.", propertyDefinition.getType().getSimpleName(), cls.getSimpleName());
            throw new ArgumentException(errorMessage, "propertyDefinition");
        }
        OutParam<Object> value = new OutParam<Object>();
        boolean result = this.tryGetProperty(propertyDefinition, value);
        if (result) {
            propertyValue.setParam(value.getParam());
        } else {
            propertyValue.setParam((Object)null);
        }
        return result;
    }

    private <T> T getPropertyValueOrException(PropertyDefinition propertyDefinition, OutParam<ServiceLocalException> serviceExceptionOutParam) {
        OutParam propertyValueOutParam = new OutParam();
        propertyValueOutParam.setParam((Object)null);
        serviceExceptionOutParam.setParam((Object)null);
        if (propertyDefinition.getVersion().ordinal() > this.getOwner().getService().getRequestedServerVersion().ordinal()) {
            serviceExceptionOutParam.setParam((Object)new ServiceVersionException(String.format("The property %s is valid only for Exchange %s or later versions.", new Object[]{propertyDefinition.getName(), propertyDefinition.getVersion()})));
            return null;
        }
        if (this.tryGetValue(propertyDefinition, propertyValueOutParam)) {
            return (T)propertyValueOutParam.getParam();
        }
        if (propertyDefinition.hasFlag(PropertyDefinitionFlags.AutoInstantiateOnRead)) {
            EwsUtilities.ewsAssert(propertyDefinition instanceof ComplexPropertyDefinitionBase, "PropertyBag.get_this[]", "propertyDefinition is marked with AutoInstantiateOnRead but is not a descendant of ComplexPropertyDefinitionBase");
            ComplexPropertyDefinitionBase complexPropertyDefinition = (ComplexPropertyDefinitionBase)propertyDefinition;
            ComplexProperty propertyValue = complexPropertyDefinition.createPropertyInstance(this.getOwner());
            propertyValueOutParam.setParam(propertyValue);
            if (propertyValue != null) {
                this.initComplexProperty(propertyValue);
                this.properties.put(propertyDefinition, propertyValue);
            }
        } else if (propertyDefinition != this.getOwner().getIdPropertyDefinition()) {
            if (!this.isPropertyLoaded(propertyDefinition)) {
                serviceExceptionOutParam.setParam((Object)new ServiceObjectPropertyException("You must load or assign this property before you can read its value.", propertyDefinition));
                return null;
            }
            if (!propertyDefinition.isNullable()) {
                String errorMessage = this.isRequestedProperty(propertyDefinition) ? "This property was requested, but it wasn't returned by the server." : "You must assign this property before you can read its value.";
                serviceExceptionOutParam.setParam((Object)new ServiceObjectPropertyException(errorMessage, propertyDefinition));
            }
        }
        return (T)propertyValueOutParam.getParam();
    }

    public void changed() {
        this.isDirty = true;
        this.getOwner().changed();
    }

    public boolean contains(PropertyDefinition propertyDefinition) {
        return this.properties.containsKey(propertyDefinition);
    }

    public <T> boolean tryGetValue(PropertyDefinition propertyDefinition, OutParam<T> propertyValueOutParam) {
        if (this.properties.containsKey(propertyDefinition)) {
            Object param = this.properties.get(propertyDefinition);
            propertyValueOutParam.setParam(param);
            return true;
        }
        propertyValueOutParam.setParam((Object)null);
        return false;
    }

    protected void propertyChanged(ComplexProperty complexProperty) {
        for (Map.Entry<PropertyDefinition, Object> keyValuePair : this.properties.entrySet()) {
            if (!keyValuePair.getValue().equals(complexProperty) || this.deletedProperties.containsKey(keyValuePair.getKey())) continue;
            PropertyBag.addToChangeList(keyValuePair.getKey(), this.modifiedProperties);
            this.changed();
        }
    }

    protected void deleteProperty(PropertyDefinition propertyDefinition) {
        if (!this.deletedProperties.containsKey(propertyDefinition)) {
            Object propertyValue = null;
            if (this.properties.containsKey(propertyDefinition)) {
                propertyValue = this.properties.get(propertyDefinition);
            }
            this.properties.remove(propertyDefinition);
            this.modifiedProperties.remove(propertyDefinition);
            this.deletedProperties.put(propertyDefinition, propertyValue);
            if (propertyValue instanceof ComplexProperty) {
                ComplexProperty complexProperty = (ComplexProperty)propertyValue;
                complexProperty.addOnChangeEvent(this);
            }
        }
    }

    protected void clear() {
        this.clearChangeLog();
        this.properties.clear();
        this.loadedProperties.clear();
        this.requestedPropertySet = null;
    }

    public void clearChangeLog() {
        this.deletedProperties.clear();
        this.modifiedProperties.clear();
        this.addedProperties.clear();
        for (Map.Entry<PropertyDefinition, Object> keyValuePair : this.properties.entrySet()) {
            if (!(keyValuePair.getValue() instanceof ComplexProperty)) continue;
            ComplexProperty complexProperty = (ComplexProperty)keyValuePair.getValue();
            complexProperty.clearChangeLog();
        }
        this.isDirty = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadFromXml(EwsServiceXmlReader reader, boolean clear, PropertySet requestedPropertySet, boolean onlySummaryPropertiesRequested) throws Exception {
        if (clear) {
            this.clear();
        }
        this.loading = true;
        this.requestedPropertySet = requestedPropertySet;
        this.onlySummaryPropertiesRequested = onlySummaryPropertiesRequested;
        try {
            do {
                reader.read();
                if (reader.getNodeType().getNodeType() != 1) continue;
                OutParam<PropertyDefinition> propertyDefinitionOut = new OutParam<PropertyDefinition>();
                if (this.getOwner().schema().tryGetPropertyDefinition(reader.getLocalName(), propertyDefinitionOut)) {
                    PropertyDefinition propertyDefinition = (PropertyDefinition)propertyDefinitionOut.getParam();
                    propertyDefinition.loadPropertyValueFromXml(reader, this);
                    this.loadedProperties.add(propertyDefinition);
                    continue;
                }
                reader.skipCurrentElement();
            } while (!reader.isEndElement(XmlNamespace.Types, this.getOwner().getXmlElementName()));
            this.clearChangeLog();
        }
        finally {
            this.loading = false;
        }
    }

    public void writeToXml(EwsServiceXmlWriter writer) throws Exception {
        writer.writeStartElement(XmlNamespace.Types, this.getOwner().getXmlElementName());
        for (PropertyDefinition propertyDefinition : this.getOwner().getSchema()) {
            if (!propertyDefinition.hasFlag(PropertyDefinitionFlags.CanSet, writer.getService().getRequestedServerVersion()) || !this.contains(propertyDefinition)) continue;
            propertyDefinition.writePropertyValueToXml(writer, this, false);
        }
        writer.writeEndElement();
    }

    public void writeToXmlForUpdate(EwsServiceXmlWriter writer) throws Exception {
        writer.writeStartElement(XmlNamespace.Types, this.getOwner().getChangeXmlElementName());
        this.getOwner().getId().writeToXml(writer);
        writer.writeStartElement(XmlNamespace.Types, "Updates");
        for (PropertyDefinition propertyDefinition : this.addedProperties) {
            this.writeSetUpdateToXml(writer, propertyDefinition);
        }
        for (PropertyDefinition propertyDefinition : this.modifiedProperties) {
            this.writeSetUpdateToXml(writer, propertyDefinition);
        }
        for (Map.Entry<PropertyDefinition, Object> property : this.deletedProperties.entrySet()) {
            this.writeDeleteUpdateToXml(writer, property.getKey(), property.getValue());
        }
        writer.writeEndElement();
        writer.writeEndElement();
    }

    public boolean getIsUpdateCallNecessary() {
        ArrayList<PropertyDefinition> propertyDefinitions = new ArrayList<PropertyDefinition>();
        propertyDefinitions.addAll(this.addedProperties);
        propertyDefinitions.addAll(this.modifiedProperties);
        propertyDefinitions.addAll(this.deletedProperties.keySet());
        for (PropertyDefinition propertyDefinition : propertyDefinitions) {
            if (!propertyDefinition.hasFlag(PropertyDefinitionFlags.CanUpdate)) continue;
            return true;
        }
        return false;
    }

    private void initComplexProperty(ComplexProperty complexProperty) {
        if (complexProperty != null) {
            complexProperty.addOnChangeEvent(this);
            if (complexProperty instanceof IOwnedProperty) {
                IOwnedProperty ownedProperty = (IOwnedProperty)((Object)complexProperty);
                ownedProperty.setOwner(this.getOwner());
            }
        }
    }

    private void writeSetUpdateToXml(EwsServiceXmlWriter writer, PropertyDefinition propertyDefinition) throws Exception {
        if (propertyDefinition.hasFlag(PropertyDefinitionFlags.CanUpdate)) {
            Object propertyValue = this.getObjectFromPropertyDefinition(propertyDefinition);
            boolean handled = false;
            if (propertyValue instanceof ICustomXmlUpdateSerializer) {
                ICustomXmlUpdateSerializer updateSerializer = (ICustomXmlUpdateSerializer)propertyValue;
                handled = updateSerializer.writeSetUpdateToXml(writer, this.getOwner(), propertyDefinition);
            }
            if (!handled) {
                writer.writeStartElement(XmlNamespace.Types, this.getOwner().getSetFieldXmlElementName());
                propertyDefinition.writeToXml(writer);
                writer.writeStartElement(XmlNamespace.Types, this.getOwner().getXmlElementName());
                propertyDefinition.writePropertyValueToXml(writer, this, true);
                writer.writeEndElement();
                writer.writeEndElement();
            }
        }
    }

    private void writeDeleteUpdateToXml(EwsServiceXmlWriter writer, PropertyDefinition propertyDefinition, Object propertyValue) throws Exception {
        if (propertyDefinition.hasFlag(PropertyDefinitionFlags.CanDelete)) {
            boolean handled = false;
            if (propertyValue instanceof ICustomXmlUpdateSerializer) {
                ICustomXmlUpdateSerializer updateSerializer = (ICustomXmlUpdateSerializer)propertyValue;
                handled = updateSerializer.writeDeleteUpdateToXml(writer, this.getOwner());
            }
            if (!handled) {
                writer.writeStartElement(XmlNamespace.Types, this.getOwner().getDeleteFieldXmlElementName());
                propertyDefinition.writeToXml(writer);
                writer.writeEndElement();
            }
        }
    }

    public void validate() throws Exception {
        for (PropertyDefinition propertyDefinition : this.addedProperties) {
            this.validatePropertyValue(propertyDefinition);
        }
        for (PropertyDefinition propertyDefinition : this.modifiedProperties) {
            this.validatePropertyValue(propertyDefinition);
        }
    }

    private void validatePropertyValue(PropertyDefinition propertyDefinition) throws Exception {
        Object propertyValue;
        OutParam<Object> propertyValueOut = new OutParam<Object>();
        if (this.tryGetProperty(propertyDefinition, propertyValueOut) && (propertyValue = propertyValueOut.getParam()) instanceof ISelfValidate) {
            ISelfValidate validatingValue = (ISelfValidate)propertyValue;
            validatingValue.validate();
        }
    }

    public <T> T getObjectFromPropertyDefinition(PropertyDefinition propertyDefinition) throws ServiceLocalException {
        OutParam<ServiceLocalException> serviceExceptionOut = new OutParam<ServiceLocalException>();
        T propertyValue = this.getPropertyValueOrException(propertyDefinition, serviceExceptionOut);
        ServiceLocalException serviceException = (ServiceLocalException)serviceExceptionOut.getParam();
        if (serviceException != null) {
            throw serviceException;
        }
        return propertyValue;
    }

    public void setObjectFromPropertyDefinition(PropertyDefinition propertyDefinition, Object object) throws Exception {
        if (propertyDefinition.getVersion().ordinal() > this.getOwner().getService().getRequestedServerVersion().ordinal()) {
            throw new ServiceVersionException(String.format("The property %s is valid only for Exchange %s or later versions.", new Object[]{propertyDefinition.getName(), propertyDefinition.getVersion()}));
        }
        if (!this.loading) {
            if (this.getOwner().isNew() && !propertyDefinition.hasFlag(PropertyDefinitionFlags.CanSet, this.getOwner().getService().getRequestedServerVersion())) {
                throw new ServiceObjectPropertyException("This property is read-only and can't be set.", propertyDefinition);
            }
            if (!this.getOwner().isNew()) {
                Item ownerItem;
                if (this.getOwner() instanceof Item && (ownerItem = (Item)this.getOwner()).isAttachment()) {
                    throw new ServiceObjectPropertyException("Item attachments can't be updated.", propertyDefinition);
                }
                if (object == null && !propertyDefinition.hasFlag(PropertyDefinitionFlags.CanDelete)) {
                    throw new ServiceObjectPropertyException("This property can't be deleted.", propertyDefinition);
                }
                if (!propertyDefinition.hasFlag(PropertyDefinitionFlags.CanUpdate)) {
                    throw new ServiceObjectPropertyException("This property can't be updated.", propertyDefinition);
                }
            }
        }
        if (object == null) {
            this.deleteProperty(propertyDefinition);
        } else {
            ComplexProperty complexProperty = null;
            Object currentValue = null;
            if (this.properties.containsKey(propertyDefinition) && (currentValue = this.properties.get(propertyDefinition)) instanceof ComplexProperty) {
                complexProperty = (ComplexProperty)currentValue;
                complexProperty.removeChangeEvent(this);
            }
            if (this.deletedProperties.containsKey(propertyDefinition)) {
                this.deletedProperties.remove(propertyDefinition);
                PropertyBag.addToChangeList(propertyDefinition, this.modifiedProperties);
            } else if (!this.properties.containsKey(propertyDefinition)) {
                PropertyBag.addToChangeList(propertyDefinition, this.addedProperties);
            } else if (!this.modifiedProperties.contains(propertyDefinition)) {
                PropertyBag.addToChangeList(propertyDefinition, this.modifiedProperties);
            }
            if (object instanceof ComplexProperty) {
                this.initComplexProperty((ComplexProperty)object);
            }
            this.properties.put(propertyDefinition, object);
            this.changed();
        }
    }

    @Override
    public void complexPropertyChanged(ComplexProperty complexProperty) {
        this.propertyChanged(complexProperty);
    }
}

