/*
 * Decompiled with CFR 0.152.
 */
package microsoft.exchange.webservices.data.core.request;

import java.util.ArrayList;
import java.util.ListIterator;
import microsoft.exchange.webservices.data.core.EwsServiceXmlWriter;
import microsoft.exchange.webservices.data.core.EwsUtilities;
import microsoft.exchange.webservices.data.core.ExchangeService;
import microsoft.exchange.webservices.data.core.enumeration.misc.ExchangeVersion;
import microsoft.exchange.webservices.data.core.enumeration.misc.XmlNamespace;
import microsoft.exchange.webservices.data.core.enumeration.service.error.ServiceErrorHandling;
import microsoft.exchange.webservices.data.core.exception.service.local.ServiceLocalException;
import microsoft.exchange.webservices.data.core.request.MultiResponseServiceRequest;
import microsoft.exchange.webservices.data.core.response.CreateAttachmentResponse;
import microsoft.exchange.webservices.data.property.complex.Attachment;
import microsoft.exchange.webservices.data.property.complex.ItemAttachment;

public final class CreateAttachmentRequest
extends MultiResponseServiceRequest<CreateAttachmentResponse> {
    private String parentItemId;
    private ArrayList<Attachment> attachments = new ArrayList();

    public ArrayList<Attachment> getAttachments() {
        return this.attachments;
    }

    public CreateAttachmentRequest(ExchangeService service, ServiceErrorHandling errorHandlingMode) throws Exception {
        super(service, errorHandlingMode);
    }

    @Override
    protected void validate() throws Exception {
        super.validate();
        EwsUtilities.validateParam(this.parentItemId, "ParentItemId");
    }

    @Override
    protected int getExpectedResponseMessageCount() {
        return this.attachments.size();
    }

    @Override
    public String getXmlElementName() {
        return "CreateAttachment";
    }

    @Override
    protected String getResponseXmlElementName() {
        return "CreateAttachmentResponse";
    }

    @Override
    protected String getResponseMessageXmlElementName() {
        return "CreateAttachmentResponseMessage";
    }

    @Override
    protected ExchangeVersion getMinimumRequiredServerVersion() {
        return ExchangeVersion.Exchange2007_SP1;
    }

    protected boolean emitTimeZoneHeader() throws ServiceLocalException, Exception {
        ListIterator<Attachment> items = this.getAttachments().listIterator();
        while (items.hasNext()) {
            ItemAttachment itemAttachment = (ItemAttachment)items.next();
            if (itemAttachment.getItem() == null || !itemAttachment.getItem().getIsTimeZoneHeaderRequired(false)) continue;
            return true;
        }
        return false;
    }

    public String getParentItemId() {
        return this.parentItemId;
    }

    public void setParentItemId(String parentItemId) {
        this.parentItemId = parentItemId;
    }

    @Override
    protected void writeElementsToXml(EwsServiceXmlWriter writer) throws Exception {
        writer.writeStartElement(XmlNamespace.Messages, "ParentItemId");
        writer.writeAttributeValue("Id", this.parentItemId);
        writer.writeEndElement();
        writer.writeStartElement(XmlNamespace.Messages, "Attachments");
        for (Attachment attachment : this.attachments) {
            attachment.writeToXml(writer, attachment.getXmlElementName());
        }
        writer.writeEndElement();
    }

    @Override
    protected CreateAttachmentResponse createServiceResponse(ExchangeService service, int responseIndex) {
        return new CreateAttachmentResponse(this.attachments.get(responseIndex));
    }
}

