/*
 * Decompiled with CFR 0.152.
 */
package microsoft.exchange.webservices.data.core.request;

import java.util.EnumSet;
import microsoft.exchange.webservices.data.core.EwsServiceXmlWriter;
import microsoft.exchange.webservices.data.core.EwsUtilities;
import microsoft.exchange.webservices.data.core.ExchangeService;
import microsoft.exchange.webservices.data.core.enumeration.misc.ExchangeVersion;
import microsoft.exchange.webservices.data.core.enumeration.misc.UserConfigurationProperties;
import microsoft.exchange.webservices.data.core.enumeration.misc.XmlNamespace;
import microsoft.exchange.webservices.data.core.enumeration.service.error.ServiceErrorHandling;
import microsoft.exchange.webservices.data.core.exception.service.local.ServiceLocalException;
import microsoft.exchange.webservices.data.core.request.MultiResponseServiceRequest;
import microsoft.exchange.webservices.data.core.response.GetUserConfigurationResponse;
import microsoft.exchange.webservices.data.misc.UserConfiguration;
import microsoft.exchange.webservices.data.property.complex.FolderId;

public class GetUserConfigurationRequest
extends MultiResponseServiceRequest<GetUserConfigurationResponse> {
    private String name;
    private FolderId parentFolderId;
    private EnumSet<UserConfigurationProperties> properties;
    private UserConfiguration userConfiguration;

    @Override
    protected void validate() throws ServiceLocalException, Exception {
        super.validate();
        EwsUtilities.validateParam(this.name, "name");
        EwsUtilities.validateParam(this.parentFolderId, "parentFolderId");
        this.getParentFolderId().validate(this.getService().getRequestedServerVersion());
    }

    @Override
    protected GetUserConfigurationResponse createServiceResponse(ExchangeService service, int responseIndex) throws Exception {
        if (this.userConfiguration == null) {
            this.userConfiguration = new UserConfiguration(service, this.properties);
            this.userConfiguration.setName(this.name);
            this.userConfiguration.setParentFolderId(this.parentFolderId);
        }
        return new GetUserConfigurationResponse(this.userConfiguration);
    }

    @Override
    protected ExchangeVersion getMinimumRequiredServerVersion() {
        return ExchangeVersion.Exchange2010;
    }

    @Override
    protected int getExpectedResponseMessageCount() {
        return 1;
    }

    @Override
    public String getXmlElementName() {
        return "GetUserConfiguration";
    }

    @Override
    protected String getResponseXmlElementName() {
        return "GetUserConfigurationResponse";
    }

    @Override
    protected String getResponseMessageXmlElementName() {
        return "GetUserConfigurationResponseMessage";
    }

    @Override
    protected void writeElementsToXml(EwsServiceXmlWriter writer) throws Exception {
        String EnumDelimiter = ",";
        UserConfiguration.writeUserConfigurationNameToXml(writer, XmlNamespace.Messages, this.name, this.parentFolderId);
        writer.writeElementValue(XmlNamespace.Messages, "UserConfigurationProperties", this.properties.toString().replace(",", "").replace("[", "").replace("]", ""));
    }

    public GetUserConfigurationRequest(ExchangeService service) throws Exception {
        super(service, ServiceErrorHandling.ThrowOnError);
    }

    protected String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    protected FolderId getParentFolderId() {
        return this.parentFolderId;
    }

    public void setParentFolderId(FolderId parentFolderId) {
        this.parentFolderId = parentFolderId;
    }

    protected UserConfiguration getUserConfiguration() {
        return this.userConfiguration;
    }

    public void setUserConfiguration(UserConfiguration userConfiguration) {
        this.userConfiguration = userConfiguration;
        this.name = this.userConfiguration.getName();
        this.parentFolderId = this.userConfiguration.getParentFolderId();
    }

    protected EnumSet<UserConfigurationProperties> getProperties() {
        return this.properties;
    }

    public void setProperties(EnumSet<UserConfigurationProperties> properties) {
        this.properties = properties;
    }
}

