/*
 * Decompiled with CFR 0.152.
 */
package microsoft.exchange.webservices.data.core.request;

import microsoft.exchange.webservices.data.core.EwsServiceXmlWriter;
import microsoft.exchange.webservices.data.core.EwsUtilities;
import microsoft.exchange.webservices.data.core.ExchangeService;
import microsoft.exchange.webservices.data.core.enumeration.misc.XmlNamespace;
import microsoft.exchange.webservices.data.core.enumeration.service.error.ServiceErrorHandling;
import microsoft.exchange.webservices.data.core.request.MoveCopyRequest;
import microsoft.exchange.webservices.data.core.response.ServiceResponse;
import microsoft.exchange.webservices.data.core.service.folder.Folder;
import microsoft.exchange.webservices.data.misc.FolderIdWrapperList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

abstract class MoveCopyFolderRequest<TResponse extends ServiceResponse>
extends MoveCopyRequest<Folder, TResponse> {
    private static final Log LOG = LogFactory.getLog(MoveCopyFolderRequest.class);
    private FolderIdWrapperList folderIds = new FolderIdWrapperList();

    @Override
    protected void validate() throws Exception {
        super.validate();
        EwsUtilities.validateParamCollection(this.getFolderIds().iterator(), "FolderIds");
        this.getFolderIds().validate(this.getService().getRequestedServerVersion());
    }

    protected MoveCopyFolderRequest(ExchangeService service, ServiceErrorHandling errorHandlingMode) throws Exception {
        super(service, errorHandlingMode);
    }

    @Override
    protected void writeIdsToXml(EwsServiceXmlWriter writer) {
        try {
            this.folderIds.writeToXml(writer, XmlNamespace.Messages, "FolderIds");
        }
        catch (Exception e) {
            LOG.error((Object)e);
        }
    }

    @Override
    protected int getExpectedResponseMessageCount() {
        return this.getFolderIds().getCount();
    }

    public FolderIdWrapperList getFolderIds() {
        return this.folderIds;
    }
}

