/*
 * Decompiled with CFR 0.152.
 */
package microsoft.exchange.webservices.data.core.request;

import microsoft.exchange.webservices.data.core.EwsServiceXmlWriter;
import microsoft.exchange.webservices.data.core.EwsUtilities;
import microsoft.exchange.webservices.data.core.ExchangeService;
import microsoft.exchange.webservices.data.core.PropertySet;
import microsoft.exchange.webservices.data.core.enumeration.misc.ExchangeVersion;
import microsoft.exchange.webservices.data.core.enumeration.misc.XmlNamespace;
import microsoft.exchange.webservices.data.core.enumeration.service.ServiceObjectType;
import microsoft.exchange.webservices.data.core.enumeration.service.SyncFolderItemsScope;
import microsoft.exchange.webservices.data.core.enumeration.service.error.ServiceErrorHandling;
import microsoft.exchange.webservices.data.core.exception.misc.ArgumentException;
import microsoft.exchange.webservices.data.core.exception.service.local.ServiceVersionException;
import microsoft.exchange.webservices.data.core.request.MultiResponseServiceRequest;
import microsoft.exchange.webservices.data.core.response.SyncFolderItemsResponse;
import microsoft.exchange.webservices.data.misc.ItemIdWrapperList;
import microsoft.exchange.webservices.data.property.complex.FolderId;

public class SyncFolderItemsRequest
extends MultiResponseServiceRequest<SyncFolderItemsResponse> {
    private PropertySet propertySet;
    private FolderId syncFolderId;
    private SyncFolderItemsScope syncScope;
    private String syncState;
    private ItemIdWrapperList ignoredItemIds = new ItemIdWrapperList();
    private int maxChangesReturned = 100;

    public SyncFolderItemsRequest(ExchangeService service) throws Exception {
        super(service, ServiceErrorHandling.ThrowOnError);
    }

    @Override
    protected SyncFolderItemsResponse createServiceResponse(ExchangeService service, int responseIndex) {
        return new SyncFolderItemsResponse(this.getPropertySet());
    }

    @Override
    protected int getExpectedResponseMessageCount() {
        return 1;
    }

    @Override
    public String getXmlElementName() {
        return "SyncFolderItems";
    }

    @Override
    protected String getResponseXmlElementName() {
        return "SyncFolderItemsResponse";
    }

    @Override
    protected String getResponseMessageXmlElementName() {
        return "SyncFolderItemsResponseMessage";
    }

    @Override
    protected void validate() throws Exception {
        super.validate();
        EwsUtilities.validateParam(this.getPropertySet(), "PropertySet");
        EwsUtilities.validateParam(this.getSyncFolderId(), "SyncFolderId");
        this.getSyncFolderId().validate(this.getService().getRequestedServerVersion());
        if (this.getService().getRequestedServerVersion().compareTo(ExchangeVersion.Exchange2010) < 0 && this.syncScope != SyncFolderItemsScope.NormalItems) {
            throw new ServiceVersionException(String.format("Enumeration value %s in enumeration type %s is only valid for Exchange version %s or later.", new Object[]{this.getSyncScope().toString(), this.getSyncScope().name(), ExchangeVersion.Exchange2010}));
        }
        this.getPropertySet().validateForRequest(this, true);
    }

    @Override
    protected void writeElementsToXml(EwsServiceXmlWriter writer) throws Exception {
        this.getPropertySet().writeToXml(writer, ServiceObjectType.Item);
        writer.writeStartElement(XmlNamespace.Messages, "SyncFolderId");
        this.getSyncFolderId().writeToXml(writer);
        writer.writeEndElement();
        writer.writeElementValue(XmlNamespace.Messages, "SyncState", this.getSyncState());
        this.getIgnoredItemIds().writeToXml(writer, XmlNamespace.Messages, "Ignore");
        writer.writeElementValue(XmlNamespace.Messages, "MaxChangesReturned", this.getMaxChangesReturned());
        if (this.getService().getRequestedServerVersion().compareTo(ExchangeVersion.Exchange2010) >= 0) {
            writer.writeElementValue(XmlNamespace.Messages, "SyncScope", (Object)this.syncScope);
        }
    }

    @Override
    protected ExchangeVersion getMinimumRequiredServerVersion() {
        return ExchangeVersion.Exchange2007_SP1;
    }

    public PropertySet getPropertySet() {
        return this.propertySet;
    }

    public void setPropertySet(PropertySet propertySet) {
        this.propertySet = propertySet;
    }

    public FolderId getSyncFolderId() {
        return this.syncFolderId;
    }

    public void setSyncFolderId(FolderId syncFolderId) {
        this.syncFolderId = syncFolderId;
    }

    public SyncFolderItemsScope getSyncScope() {
        return this.syncScope;
    }

    public void setSyncScope(SyncFolderItemsScope syncScope) {
        this.syncScope = syncScope;
    }

    public String getSyncState() {
        return this.syncState;
    }

    public void setSyncState(String syncState) {
        this.syncState = syncState;
    }

    public ItemIdWrapperList getIgnoredItemIds() {
        return this.ignoredItemIds;
    }

    public int getMaxChangesReturned() {
        return this.maxChangesReturned;
    }

    public void setMaxChangesReturned(int maxChangesReturned) throws ArgumentException {
        if (maxChangesReturned < 1 || maxChangesReturned > 512) {
            throw new ArgumentException("MaxChangesReturned must be between 1 and 512.");
        }
        this.maxChangesReturned = maxChangesReturned;
    }
}

