/*
 * Decompiled with CFR 0.152.
 */
package microsoft.exchange.webservices.data.core.request;

import microsoft.exchange.webservices.data.core.EwsServiceXmlReader;
import microsoft.exchange.webservices.data.core.EwsServiceXmlWriter;
import microsoft.exchange.webservices.data.core.EwsUtilities;
import microsoft.exchange.webservices.data.core.ExchangeService;
import microsoft.exchange.webservices.data.core.enumeration.misc.ExchangeVersion;
import microsoft.exchange.webservices.data.core.enumeration.misc.XmlNamespace;
import microsoft.exchange.webservices.data.core.enumeration.service.ServiceResult;
import microsoft.exchange.webservices.data.core.exception.service.remote.UpdateInboxRulesException;
import microsoft.exchange.webservices.data.core.request.SimpleServiceRequestBase;
import microsoft.exchange.webservices.data.core.response.UpdateInboxRulesResponse;
import microsoft.exchange.webservices.data.property.complex.RuleOperation;

public final class UpdateInboxRulesRequest
extends SimpleServiceRequestBase<UpdateInboxRulesResponse> {
    private String mailboxSmtpAddress;
    private boolean removeOutlookRuleBlob;
    private Iterable<RuleOperation> inboxRuleOperations;

    public UpdateInboxRulesRequest(ExchangeService service) throws Exception {
        super(service);
    }

    @Override
    public String getXmlElementName() {
        return "UpdateInboxRules";
    }

    @Override
    protected void writeElementsToXml(EwsServiceXmlWriter writer) throws Exception {
        if (this.mailboxSmtpAddress != null && !this.mailboxSmtpAddress.isEmpty()) {
            writer.writeElementValue(XmlNamespace.Messages, "MailboxSmtpAddress", this.mailboxSmtpAddress);
        }
        writer.writeElementValue(XmlNamespace.Messages, "RemoveOutlookRuleBlob", this.removeOutlookRuleBlob);
        writer.writeStartElement(XmlNamespace.Messages, "Operations");
        for (RuleOperation operation : this.inboxRuleOperations) {
            operation.writeToXml(writer, operation.getXmlElementName());
        }
        writer.writeEndElement();
    }

    @Override
    protected String getResponseXmlElementName() {
        return "UpdateInboxRulesResponse";
    }

    @Override
    protected UpdateInboxRulesResponse parseResponse(EwsServiceXmlReader reader) throws Exception {
        UpdateInboxRulesResponse response = new UpdateInboxRulesResponse();
        response.loadFromXml(reader, "UpdateInboxRulesResponse");
        return response;
    }

    @Override
    protected ExchangeVersion getMinimumRequiredServerVersion() {
        return ExchangeVersion.Exchange2010_SP1;
    }

    @Override
    protected void validate() throws Exception {
        if (this.inboxRuleOperations == null) {
            throw new IllegalArgumentException("RuleOperations cannot be null.Operations");
        }
        int operationCount = 0;
        for (RuleOperation operation : this.inboxRuleOperations) {
            EwsUtilities.validateParam(operation, "RuleOperation");
            ++operationCount;
        }
        if (operationCount == 0) {
            throw new IllegalArgumentException("RuleOperations cannot be empty.Operations");
        }
        this.getService().validate();
    }

    public UpdateInboxRulesResponse execute() throws Exception {
        UpdateInboxRulesResponse serviceResponse = (UpdateInboxRulesResponse)this.internalExecute();
        if (serviceResponse.getResult() == ServiceResult.Error) {
            throw new UpdateInboxRulesException(serviceResponse, this.inboxRuleOperations);
        }
        return serviceResponse;
    }

    protected String getMailboxSmtpAddress() {
        return this.mailboxSmtpAddress;
    }

    public void setMailboxSmtpAddress(String value) {
        this.mailboxSmtpAddress = value;
    }

    protected boolean getRemoveOutlookRuleBlob() {
        return this.removeOutlookRuleBlob;
    }

    public void setRemoveOutlookRuleBlob(boolean value) {
        this.removeOutlookRuleBlob = value;
    }

    protected Iterable<RuleOperation> getInboxRuleOperations() {
        return this.inboxRuleOperations;
    }

    public void setInboxRuleOperations(Iterable<RuleOperation> value) {
        this.inboxRuleOperations = value;
    }
}

