/*
 * Decompiled with CFR 0.152.
 */
package microsoft.exchange.webservices.data.core.service.response;

import microsoft.exchange.webservices.data.core.EwsUtilities;
import microsoft.exchange.webservices.data.core.enumeration.misc.ExchangeVersion;
import microsoft.exchange.webservices.data.core.enumeration.service.ResponseMessageType;
import microsoft.exchange.webservices.data.core.service.item.EmailMessage;
import microsoft.exchange.webservices.data.core.service.item.Item;
import microsoft.exchange.webservices.data.core.service.response.ResponseObject;
import microsoft.exchange.webservices.data.core.service.schema.EmailMessageSchema;
import microsoft.exchange.webservices.data.core.service.schema.ItemSchema;
import microsoft.exchange.webservices.data.core.service.schema.ResponseMessageSchema;
import microsoft.exchange.webservices.data.core.service.schema.ResponseObjectSchema;
import microsoft.exchange.webservices.data.core.service.schema.ServiceObjectSchema;
import microsoft.exchange.webservices.data.property.complex.EmailAddressCollection;
import microsoft.exchange.webservices.data.property.complex.MessageBody;

public final class ResponseMessage
extends ResponseObject<EmailMessage> {
    private ResponseMessageType responseType;

    public ResponseMessage(Item referenceItem, ResponseMessageType responseType) throws Exception {
        super(referenceItem);
        this.responseType = responseType;
    }

    @Override
    public ServiceObjectSchema getSchema() {
        return ResponseMessageSchema.Instance;
    }

    @Override
    public ExchangeVersion getMinimumRequiredServerVersion() {
        return ExchangeVersion.Exchange2007_SP1;
    }

    @Override
    protected String getXmlElementNameOverride() {
        if (this.responseType == ResponseMessageType.Reply) {
            return "ReplyToItem";
        }
        if (this.responseType == ResponseMessageType.ReplyAll) {
            return "ReplyAllToItem";
        }
        if (this.responseType == ResponseMessageType.Forward) {
            return "ForwardItem";
        }
        EwsUtilities.ewsAssert(false, "ResponseMessage.GetXmlElementNameOverride", "An unexpected value for responseType could not be handled.");
        return null;
    }

    public ResponseMessageType getResponseType() {
        return this.responseType;
    }

    public MessageBody getBody() throws Exception {
        return (MessageBody)this.getObjectFromPropertyDefinition(ItemSchema.Body);
    }

    public void setBody(MessageBody value) throws Exception {
        this.getPropertyBag().setObjectFromPropertyDefinition(ItemSchema.Body, value);
    }

    public EmailAddressCollection getToRecipients() throws Exception {
        return (EmailAddressCollection)this.getObjectFromPropertyDefinition(EmailMessageSchema.ToRecipients);
    }

    public EmailAddressCollection getCcRecipients() throws Exception {
        return (EmailAddressCollection)this.getObjectFromPropertyDefinition(EmailMessageSchema.CcRecipients);
    }

    public EmailAddressCollection getBccRecipients() throws Exception {
        return (EmailAddressCollection)this.getObjectFromPropertyDefinition(EmailMessageSchema.BccRecipients);
    }

    public String getSubject() throws Exception {
        return (String)this.getObjectFromPropertyDefinition(EmailMessageSchema.Subject);
    }

    public void setSubject(String value) throws Exception {
        this.getPropertyBag().setObjectFromPropertyDefinition(EmailMessageSchema.Subject, value);
    }

    public MessageBody getBodyPrefix() throws Exception {
        return (MessageBody)this.getObjectFromPropertyDefinition(ResponseObjectSchema.BodyPrefix);
    }

    public void setBodyPrefix(MessageBody value) throws Exception {
        this.getPropertyBag().setObjectFromPropertyDefinition(ResponseObjectSchema.BodyPrefix, value);
    }
}

