/*
 * Decompiled with CFR 0.152.
 */
package microsoft.exchange.webservices.data.misc.availability;

import javax.xml.stream.XMLStreamException;
import microsoft.exchange.webservices.data.core.EwsServiceXmlReader;
import microsoft.exchange.webservices.data.core.EwsServiceXmlWriter;
import microsoft.exchange.webservices.data.core.EwsUtilities;
import microsoft.exchange.webservices.data.core.enumeration.misc.XmlNamespace;
import microsoft.exchange.webservices.data.core.enumeration.property.time.DayOfTheWeek;
import microsoft.exchange.webservices.data.core.exception.service.local.ServiceXmlSerializationException;
import microsoft.exchange.webservices.data.misc.TimeSpan;
import microsoft.exchange.webservices.data.property.complex.ComplexProperty;

final class LegacyAvailabilityTimeZoneTime
extends ComplexProperty {
    private TimeSpan delta;
    private int year;
    private int month;
    private int dayOrder;
    private DayOfTheWeek dayOfTheWeek;
    private TimeSpan timeOfDay;

    protected LegacyAvailabilityTimeZoneTime() {
    }

    @Override
    public boolean tryReadElementFromXml(EwsServiceXmlReader reader) throws Exception {
        if (reader.getLocalName().equals("Bias")) {
            this.delta = new TimeSpan((long)reader.readElementValue(Integer.class).intValue() * 60L * 1000L);
            return true;
        }
        if (reader.getLocalName().equals("Time")) {
            this.timeOfDay = TimeSpan.parse(reader.readElementValue());
            return true;
        }
        if (reader.getLocalName().equals("DayOrder")) {
            this.dayOrder = reader.readElementValue(Integer.class);
            return true;
        }
        if (reader.getLocalName().equals("DayOfWeek")) {
            this.dayOfTheWeek = reader.readElementValue(DayOfTheWeek.class);
            return true;
        }
        if (reader.getLocalName().equals("Month")) {
            this.month = reader.readElementValue(Integer.class);
            return true;
        }
        if (reader.getLocalName().equals("Year")) {
            this.year = reader.readElementValue(Integer.class);
            return true;
        }
        return false;
    }

    @Override
    public void writeElementsToXml(EwsServiceXmlWriter writer) throws ServiceXmlSerializationException, XMLStreamException {
        writer.writeElementValue(XmlNamespace.Types, "Bias", (int)this.delta.getMinutes());
        writer.writeElementValue(XmlNamespace.Types, "Time", EwsUtilities.timeSpanToXSTime(this.timeOfDay));
        writer.writeElementValue(XmlNamespace.Types, "DayOrder", this.dayOrder);
        writer.writeElementValue(XmlNamespace.Types, "Month", this.month);
        if (this.getYear() == 0) {
            writer.writeElementValue(XmlNamespace.Types, "DayOfWeek", (Object)this.dayOfTheWeek);
        }
        if (this.getYear() != 0) {
            writer.writeElementValue(XmlNamespace.Types, "Year", this.getYear());
        }
    }

    protected boolean getHasTransitionTime() {
        return this.month >= 1 && this.month <= 12;
    }

    protected TimeSpan getDelta() {
        return this.delta;
    }

    protected void setDelta(TimeSpan delta) {
        this.delta = delta;
    }

    protected TimeSpan getTimeOfDay() {
        return this.timeOfDay;
    }

    protected void setTimeOfDay(TimeSpan timeOfDay) {
        this.timeOfDay = timeOfDay;
    }

    protected int getDayOrder() {
        return this.dayOrder;
    }

    protected void setDayOrder(int dayOrder) {
        this.dayOrder = dayOrder;
    }

    protected int getMonth() {
        return this.month;
    }

    protected void setMonth(int month) {
        this.month = month;
    }

    protected DayOfTheWeek getDayOfTheWeek() {
        return this.dayOfTheWeek;
    }

    protected void setDayOfTheWeek(DayOfTheWeek dayOfTheWeek) {
        this.dayOfTheWeek = dayOfTheWeek;
    }

    protected int getYear() {
        return this.year;
    }

    protected void setYear(int year) {
        this.year = year;
    }
}

