/*
 * Decompiled with CFR 0.152.
 */
package microsoft.exchange.webservices.data.property.complex;

import javax.xml.stream.XMLStreamException;
import microsoft.exchange.webservices.data.core.EwsServiceXmlReader;
import microsoft.exchange.webservices.data.core.EwsServiceXmlWriter;
import microsoft.exchange.webservices.data.core.EwsUtilities;
import microsoft.exchange.webservices.data.core.enumeration.misc.XmlNamespace;
import microsoft.exchange.webservices.data.core.exception.service.local.ServiceValidationException;
import microsoft.exchange.webservices.data.core.exception.service.local.ServiceXmlSerializationException;
import microsoft.exchange.webservices.data.property.complex.ComplexProperty;
import microsoft.exchange.webservices.data.property.complex.ISearchStringProvider;

public class Mailbox
extends ComplexProperty
implements ISearchStringProvider {
    private String routingType;
    private String address;

    public Mailbox() {
    }

    public Mailbox(String smtpAddress) {
        this();
        this.setAddress(smtpAddress);
    }

    public Mailbox(String address, String routingType) {
        this(address);
        this.setRoutingType(routingType);
    }

    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public boolean isValid() {
        return this.getAddress() != null && !this.getAddress().isEmpty();
    }

    public String getRoutingType() {
        return this.routingType;
    }

    public void setRoutingType(String routingType) {
        this.routingType = routingType;
    }

    public static Mailbox getMailboxFromString(String smtpAddress) {
        return new Mailbox(smtpAddress);
    }

    @Override
    public boolean tryReadElementFromXml(EwsServiceXmlReader reader) throws Exception {
        if (reader.getLocalName().equalsIgnoreCase("EmailAddress")) {
            this.setAddress(reader.readElementValue());
            return true;
        }
        if (reader.getLocalName().equalsIgnoreCase("RoutingType")) {
            this.setRoutingType(reader.readElementValue());
            return true;
        }
        return false;
    }

    @Override
    public void writeElementsToXml(EwsServiceXmlWriter writer) throws XMLStreamException, ServiceXmlSerializationException {
        writer.writeElementValue(XmlNamespace.Types, "EmailAddress", this.address);
        writer.writeElementValue(XmlNamespace.Types, "RoutingType", this.routingType);
    }

    @Override
    public String getSearchString() {
        return this.address;
    }

    @Override
    protected void internalValidate() throws ServiceValidationException, Exception {
        super.internalValidate();
        EwsUtilities.validateNonBlankStringParamAllowNull(this.getAddress(), "address");
        EwsUtilities.validateNonBlankStringParamAllowNull(this.getRoutingType(), "routingType");
    }

    public boolean equals(Object obj) {
        if (super.equals(obj)) {
            return true;
        }
        if (!(obj instanceof Mailbox)) {
            return false;
        }
        Mailbox other = (Mailbox)obj;
        if (this.address == null && other.address == null || this.address != null && this.address.equalsIgnoreCase(other.address)) {
            return this.routingType == null && other.routingType == null || this.routingType != null && this.routingType.equalsIgnoreCase(other.routingType);
        }
        return false;
    }

    public int hashCode() {
        if (null != this.getAddress() && !this.getAddress().isEmpty()) {
            int hashCode = this.address.hashCode();
            if (null != this.getRoutingType() && !this.getRoutingType().isEmpty()) {
                hashCode ^= this.routingType.hashCode();
            }
            return hashCode;
        }
        return super.hashCode();
    }

    public String toString() {
        if (!this.isValid()) {
            return "";
        }
        if (this.routingType != null && !this.routingType.isEmpty()) {
            return this.routingType + ":" + this.address;
        }
        return this.address;
    }
}

