/*
 * Decompiled with CFR 0.152.
 */
package microsoft.exchange.webservices.data.search;

import javax.xml.stream.XMLStreamException;
import microsoft.exchange.webservices.data.core.EwsServiceXmlWriter;
import microsoft.exchange.webservices.data.core.EwsUtilities;
import microsoft.exchange.webservices.data.core.enumeration.search.ItemTraversal;
import microsoft.exchange.webservices.data.core.enumeration.search.OffsetBasePoint;
import microsoft.exchange.webservices.data.core.enumeration.service.ServiceObjectType;
import microsoft.exchange.webservices.data.core.exception.service.local.ServiceValidationException;
import microsoft.exchange.webservices.data.core.exception.service.local.ServiceVersionException;
import microsoft.exchange.webservices.data.core.exception.service.local.ServiceXmlSerializationException;
import microsoft.exchange.webservices.data.core.request.ServiceRequestBase;
import microsoft.exchange.webservices.data.search.Grouping;
import microsoft.exchange.webservices.data.search.OrderByCollection;
import microsoft.exchange.webservices.data.search.PagedView;

public final class ItemView
extends PagedView {
    private ItemTraversal traversal = ItemTraversal.Shallow;
    private OrderByCollection orderBy = new OrderByCollection();

    @Override
    protected String getViewXmlElementName() {
        return "IndexedPageItemView";
    }

    @Override
    protected ServiceObjectType getServiceObjectType() {
        return ServiceObjectType.Item;
    }

    @Override
    public void internalValidate(ServiceRequestBase request) throws ServiceVersionException, ServiceValidationException {
        super.internalValidate(request);
        EwsUtilities.validateEnumVersionValue(this.traversal, request.getService().getRequestedServerVersion());
    }

    @Override
    public void writeAttributesToXml(EwsServiceXmlWriter writer) throws ServiceXmlSerializationException {
        writer.writeAttributeValue("Traversal", (Object)this.traversal);
    }

    @Override
    protected void internalWriteSearchSettingsToXml(EwsServiceXmlWriter writer, Grouping groupBy) throws XMLStreamException, ServiceXmlSerializationException {
        super.internalWriteSearchSettingsToXml(writer, groupBy);
    }

    @Override
    public void writeOrderByToXml(EwsServiceXmlWriter writer) throws XMLStreamException, ServiceXmlSerializationException {
        this.orderBy.writeToXml(writer, "SortOrder");
    }

    public ItemView(int pageSize) {
        super(pageSize);
    }

    public ItemView(int pageSize, int offset) {
        super(pageSize, offset);
        this.setOffset(offset);
    }

    public ItemView(int pageSize, int offset, OffsetBasePoint offsetBasePoint) {
        super(pageSize, offset, offsetBasePoint);
    }

    public ItemTraversal getTraversal() {
        return this.traversal;
    }

    public void setTraversal(ItemTraversal value) {
        this.traversal = value;
    }

    public OrderByCollection getOrderBy() {
        return this.orderBy;
    }
}

