/*
 * Decompiled with CFR 0.152.
 */
package com.pig4cloud.plugin.excel.converters;

import cn.idev.excel.converters.Converter;
import cn.idev.excel.enums.CellDataTypeEnum;
import cn.idev.excel.metadata.GlobalConfiguration;
import cn.idev.excel.metadata.data.ReadCellData;
import cn.idev.excel.metadata.data.WriteCellData;
import cn.idev.excel.metadata.property.ExcelContentProperty;
import com.pig4cloud.plugin.excel.annotation.DictTypeProperty;
import com.pig4cloud.plugin.excel.handler.DictDataProvider;
import com.pig4cloud.plugin.excel.kit.SpringContextKit;
import com.pig4cloud.plugin.excel.vo.DictEnum;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import lombok.Generated;
import org.apache.commons.collections4.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum DictTypeConvert implements Converter<String>
{
    INSTANCE;

    @Generated
    private static final Logger log;
    public static final Map<String, DictEnum[]> cache;

    public Class supportJavaTypeKey() {
        return String.class;
    }

    public CellDataTypeEnum supportExcelTypeKey() {
        return CellDataTypeEnum.STRING;
    }

    public String convertToJavaData(ReadCellData<?> cellData, ExcelContentProperty contentProperty, GlobalConfiguration globalConfiguration) throws Exception {
        if (contentProperty == null) {
            return cellData.getStringValue();
        }
        Field field = contentProperty.getField();
        DictTypeProperty declaredAnnotation = field.getDeclaredAnnotation(DictTypeProperty.class);
        if (Objects.isNull(declaredAnnotation)) {
            return cellData.getStringValue();
        }
        if (declaredAnnotation.enums().length != 0) {
            DictEnum[] enums = declaredAnnotation.enums()[0].getEnumConstants();
            return DictEnum.getValueByLabel((DictEnum[])enums, (String)cellData.getStringValue());
        }
        DictEnum[] cacheEnums = cache.get(declaredAnnotation.value());
        if (cacheEnums != null) {
            return DictEnum.getValueByLabel((DictEnum[])cacheEnums, (String)cellData.getStringValue());
        }
        Map<String, DictDataProvider> beansOfType = SpringContextKit.getBeansOfType(DictDataProvider.class);
        if (MapUtils.isEmpty(beansOfType)) {
            log.error("\u8bf7\u5b9e\u73b0 DictDataProvider \u63a5\u53e3\uff0c\u63d0\u4f9b\u5b57\u5178\u6570\u636e: https://www.yuque.com/pig4cloud/ogf9nv/pkxq8xqe9r6ax4fg");
            return cellData.getStringValue();
        }
        DictDataProvider dictDataProvider = SpringContextKit.getBean(DictDataProvider.class);
        DictEnum[] dictEnums = dictDataProvider.getDict(declaredAnnotation.value());
        if (dictEnums == null) {
            log.warn("\u5b57\u5178\u6570\u636e\u4e3a\u7a7a:{}\uff0c\u81ea\u52a8\u5b57\u5178\u8f6c\u6362\u5931\u8d25", (Object)declaredAnnotation.value());
            return cellData.getStringValue();
        }
        cache.put(declaredAnnotation.value(), dictEnums);
        return DictEnum.getValueByLabel((DictEnum[])dictEnums, (String)cellData.getStringValue());
    }

    public WriteCellData<String> convertToExcelData(String value, ExcelContentProperty contentProperty, GlobalConfiguration globalConfiguration) throws Exception {
        String labelByValue;
        Field field = contentProperty.getField();
        DictTypeProperty declaredAnnotation = field.getDeclaredAnnotation(DictTypeProperty.class);
        if (Objects.isNull(declaredAnnotation)) {
            return new WriteCellData(value);
        }
        if (declaredAnnotation.enums().length != 0) {
            DictEnum[] enums = declaredAnnotation.enums()[0].getEnumConstants();
            return new WriteCellData(DictEnum.getLabelByValue((DictEnum[])enums, (String)value));
        }
        DictEnum[] cacheEnums = cache.get(declaredAnnotation.value());
        if (cacheEnums != null && (labelByValue = DictEnum.getLabelByValue((DictEnum[])cacheEnums, (String)value)) != null) {
            return new WriteCellData(labelByValue);
        }
        Map<String, DictDataProvider> beansOfType = SpringContextKit.getBeansOfType(DictDataProvider.class);
        if (MapUtils.isEmpty(beansOfType)) {
            log.error("\u8bf7\u5b9e\u73b0 DictDataProvider \u63a5\u53e3\uff0c\u63d0\u4f9b\u5b57\u5178\u6570\u636e: https://www.yuque.com/pig4cloud/ogf9nv/pkxq8xqe9r6ax4fg");
            return new WriteCellData(value);
        }
        DictDataProvider dictDataProvider = SpringContextKit.getBean(DictDataProvider.class);
        DictEnum[] dictEnums = dictDataProvider.getDict(declaredAnnotation.value());
        if (dictEnums == null) {
            log.warn("\u5b57\u5178\u6570\u636e\u4e3a\u7a7a:{}\uff0c\u81ea\u52a8\u5b57\u5178\u8f6c\u6362\u5931\u8d25", (Object)declaredAnnotation.value());
            return new WriteCellData(value);
        }
        String labelByValue2 = DictEnum.getLabelByValue((DictEnum[])dictEnums, (String)value);
        if (labelByValue2 != null) {
            cache.put(declaredAnnotation.value(), dictEnums);
            return new WriteCellData(labelByValue2);
        }
        return new WriteCellData(value);
    }

    static {
        log = LoggerFactory.getLogger(DictTypeConvert.class);
        cache = new HashMap<String, DictEnum[]>();
    }
}

