/*
 * Decompiled with CFR 0.152.
 */
package com.pig4cloud.plugin.excel.converters;

import cn.idev.excel.converters.Converter;
import cn.idev.excel.enums.CellDataTypeEnum;
import cn.idev.excel.metadata.GlobalConfiguration;
import cn.idev.excel.metadata.data.ReadCellData;
import cn.idev.excel.metadata.data.WriteCellData;
import cn.idev.excel.metadata.property.ExcelContentProperty;
import java.text.ParseException;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;

public enum LocalTimeStringConverter implements Converter<LocalTime>
{
    INSTANCE;


    public Class supportJavaTypeKey() {
        return LocalTime.class;
    }

    public CellDataTypeEnum supportExcelTypeKey() {
        return CellDataTypeEnum.STRING;
    }

    public LocalTime convertToJavaData(ReadCellData cellData, ExcelContentProperty contentProperty, GlobalConfiguration globalConfiguration) throws ParseException {
        if (contentProperty == null || contentProperty.getDateTimeFormatProperty() == null) {
            return LocalTime.parse(cellData.getStringValue());
        }
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern(contentProperty.getDateTimeFormatProperty().getFormat());
        return LocalTime.parse(cellData.getStringValue(), formatter);
    }

    public WriteCellData<String> convertToExcelData(LocalTime value, ExcelContentProperty contentProperty, GlobalConfiguration globalConfiguration) {
        DateTimeFormatter formatter = contentProperty == null || contentProperty.getDateTimeFormatProperty() == null ? DateTimeFormatter.ISO_LOCAL_TIME : DateTimeFormatter.ofPattern(contentProperty.getDateTimeFormatProperty().getFormat());
        return new WriteCellData(value.format(formatter));
    }
}

