/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.client.naming.core;

import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.client.naming.cache.ServiceInfoHolder;
import com.alibaba.nacos.client.utils.LogUtils;
import com.alibaba.nacos.common.lifecycle.Closeable;
import com.alibaba.nacos.common.utils.IoUtils;
import com.alibaba.nacos.common.utils.JacksonUtils;
import com.alibaba.nacos.common.utils.StringUtils;
import com.alibaba.nacos.common.utils.ThreadUtils;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetSocketAddress;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import org.slf4j.Logger;

public class PushReceiver
implements Runnable,
Closeable {
    private static final Charset UTF_8 = StandardCharsets.UTF_8;
    private static final int UDP_MSS = 65536;
    private static final String PUSH_PACKAGE_TYPE_DOM = "dom";
    private static final String PUSH_PACKAGE_TYPE_SERVICE = "service";
    private static final String PUSH_PACKAGE_TYPE_DUMP = "dump";
    private ScheduledExecutorService executorService;
    private DatagramSocket udpSocket;
    private ServiceInfoHolder serviceInfoHolder;
    private volatile boolean closed = false;

    public static String getPushReceiverUdpPort() {
        return System.getenv("push.receiver.udp.port");
    }

    public PushReceiver(ServiceInfoHolder serviceInfoHolder) {
        try {
            this.serviceInfoHolder = serviceInfoHolder;
            String udpPort = PushReceiver.getPushReceiverUdpPort();
            this.udpSocket = StringUtils.isEmpty((String)udpPort) ? new DatagramSocket() : new DatagramSocket(new InetSocketAddress(Integer.parseInt(udpPort)));
            this.executorService = new ScheduledThreadPoolExecutor(1, new ThreadFactory(){

                @Override
                public Thread newThread(Runnable r) {
                    Thread thread = new Thread(r);
                    thread.setDaemon(true);
                    thread.setName("com.alibaba.nacos.naming.push.receiver");
                    return thread;
                }
            });
            this.executorService.execute(this);
        }
        catch (Exception e) {
            LogUtils.NAMING_LOGGER.error("[NA] init udp socket failed", (Throwable)e);
        }
    }

    @Override
    public void run() {
        while (!this.closed) {
            try {
                String ack;
                byte[] buffer = new byte[65536];
                DatagramPacket packet = new DatagramPacket(buffer, buffer.length);
                this.udpSocket.receive(packet);
                String json = new String(IoUtils.tryDecompress((byte[])packet.getData()), UTF_8).trim();
                LogUtils.NAMING_LOGGER.info("received push data: " + json + " from " + packet.getAddress().toString());
                PushPacket pushPacket = (PushPacket)JacksonUtils.toObj((String)json, PushPacket.class);
                if (PUSH_PACKAGE_TYPE_DOM.equals(pushPacket.type) || PUSH_PACKAGE_TYPE_SERVICE.equals(pushPacket.type)) {
                    this.serviceInfoHolder.processServiceInfo(pushPacket.data);
                    ack = "{\"type\": \"push-ack\", \"lastRefTime\":\"" + pushPacket.lastRefTime + "\", \"data\":\"\"}";
                } else {
                    ack = PUSH_PACKAGE_TYPE_DUMP.equals(pushPacket.type) ? "{\"type\": \"dump-ack\", \"lastRefTime\": \"" + pushPacket.lastRefTime + "\", \"data\":\"" + StringUtils.escapeJavaScript((String)JacksonUtils.toJson(this.serviceInfoHolder.getServiceInfoMap())) + "\"}" : "{\"type\": \"unknown-ack\", \"lastRefTime\":\"" + pushPacket.lastRefTime + "\", \"data\":\"\"}";
                }
                this.udpSocket.send(new DatagramPacket(ack.getBytes(UTF_8), ack.getBytes(UTF_8).length, packet.getSocketAddress()));
            }
            catch (Exception e) {
                if (this.closed) {
                    return;
                }
                LogUtils.NAMING_LOGGER.error("[NA] error while receiving push data", (Throwable)e);
            }
        }
    }

    public void shutdown() throws NacosException {
        String className = this.getClass().getName();
        LogUtils.NAMING_LOGGER.info("{} do shutdown begin", (Object)className);
        ThreadUtils.shutdownThreadPool((ExecutorService)this.executorService, (Logger)LogUtils.NAMING_LOGGER);
        this.closed = true;
        this.udpSocket.close();
        LogUtils.NAMING_LOGGER.info("{} do shutdown stop", (Object)className);
    }

    public int getUdpPort() {
        return this.udpSocket.getLocalPort();
    }

    public static class PushPacket {
        public String type;
        public long lastRefTime;
        public String data;
    }
}

