/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.common.executor;

import com.alibaba.nacos.common.JustForTest;
import com.alibaba.nacos.common.utils.ThreadUtils;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ThreadPoolManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(ThreadPoolManager.class);
    private Map<String, Map<String, Set<ExecutorService>>> resourcesManager;
    private Map<String, Object> lockers = new ConcurrentHashMap<String, Object>(8);
    private static final ThreadPoolManager INSTANCE = new ThreadPoolManager();
    private static final AtomicBoolean CLOSED = new AtomicBoolean(false);

    public static ThreadPoolManager getInstance() {
        return INSTANCE;
    }

    private ThreadPoolManager() {
    }

    private void init() {
        this.resourcesManager = new ConcurrentHashMap<String, Map<String, Set<ExecutorService>>>(8);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register(String namespace, String group, ExecutorService executor) {
        Object monitor;
        if (!this.resourcesManager.containsKey(namespace)) {
            this.lockers.putIfAbsent(namespace, new Object());
        }
        Object object = monitor = this.lockers.get(namespace);
        synchronized (object) {
            Map<String, Set<ExecutorService>> map = this.resourcesManager.get(namespace);
            if (map == null) {
                map = new HashMap<String, Set<ExecutorService>>(8);
                map.put(group, new HashSet());
                map.get(group).add(executor);
                this.resourcesManager.put(namespace, map);
                return;
            }
            if (!map.containsKey(group)) {
                map.put(group, new HashSet());
            }
            map.get(group).add(executor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deregister(String namespace, String group) {
        if (this.resourcesManager.containsKey(namespace)) {
            Object monitor;
            Object object = monitor = this.lockers.get(namespace);
            synchronized (object) {
                this.resourcesManager.get(namespace).remove(group);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deregister(String namespace, String group, ExecutorService executor) {
        if (this.resourcesManager.containsKey(namespace)) {
            Object monitor;
            Object object = monitor = this.lockers.get(namespace);
            synchronized (object) {
                Map<String, Set<ExecutorService>> subResourceMap = this.resourcesManager.get(namespace);
                if (subResourceMap.containsKey(group)) {
                    subResourceMap.get(group).remove(executor);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy(String namespace) {
        Object monitor = this.lockers.get(namespace);
        if (monitor == null) {
            return;
        }
        Object object = monitor;
        synchronized (object) {
            Map<String, Set<ExecutorService>> subResource = this.resourcesManager.get(namespace);
            if (subResource == null) {
                return;
            }
            for (Map.Entry<String, Set<ExecutorService>> entry : subResource.entrySet()) {
                for (ExecutorService executor : entry.getValue()) {
                    ThreadUtils.shutdownThreadPool(executor);
                }
            }
            this.resourcesManager.get(namespace).clear();
            this.resourcesManager.remove(namespace);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy(String namespace, String group) {
        Object monitor = this.lockers.get(namespace);
        if (monitor == null) {
            return;
        }
        Object object = monitor;
        synchronized (object) {
            Map<String, Set<ExecutorService>> subResource = this.resourcesManager.get(namespace);
            if (subResource == null) {
                return;
            }
            Set<ExecutorService> waitDestroy = subResource.get(group);
            for (ExecutorService executor : waitDestroy) {
                ThreadUtils.shutdownThreadPool(executor);
            }
            this.resourcesManager.get(namespace).remove(group);
        }
    }

    public static void shutdown() {
        if (!CLOSED.compareAndSet(false, true)) {
            return;
        }
        Set<String> namespaces = ThreadPoolManager.INSTANCE.resourcesManager.keySet();
        for (String namespace : namespaces) {
            INSTANCE.destroy(namespace);
        }
    }

    @JustForTest
    public Map<String, Map<String, Set<ExecutorService>>> getResourcesManager() {
        return this.resourcesManager;
    }

    @JustForTest
    public Map<String, Object> getLockers() {
        return this.lockers;
    }

    static {
        INSTANCE.init();
        ThreadUtils.addShutdownHook(new Thread(new Runnable(){

            @Override
            public void run() {
                LOGGER.warn("[ThreadPoolManager] Start destroying ThreadPool");
                ThreadPoolManager.shutdown();
                LOGGER.warn("[ThreadPoolManager] Destruction of the end");
            }
        }));
    }
}

