/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.common.utils;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;

public class TypeUtils {
    public static ParameterizedType parameterize(Class<?> raw, Type ... typeArguments) {
        TypeUtils.checkParameterizeMethodParameter(raw, typeArguments);
        return new ParameterizedTypeImpl(raw, raw.getEnclosingClass(), typeArguments);
    }

    private static void checkParameterizeMethodParameter(Class<?> raw, Type ... typeArguments) {
        if (raw == null) {
            throw new NullPointerException("raw cannot be null");
        }
        if (typeArguments == null) {
            throw new NullPointerException("typeArguments cannot be null");
        }
        if (typeArguments.length != raw.getTypeParameters().length) {
            throw new IllegalArgumentException(String.format("invalid number of type parameters specified: expected %s, got %s", raw.getTypeParameters().length, typeArguments.length));
        }
        for (int i = 0; i < typeArguments.length; ++i) {
            if (typeArguments[i] != null) continue;
            throw new IllegalArgumentException("There can be no null in typeArguments");
        }
    }

    private static final class ParameterizedTypeImpl
    implements ParameterizedType {
        private final Class<?> raw;
        private final Type useOwner;
        private final Type[] typeArguments;

        private ParameterizedTypeImpl(Class<?> raw, Type useOwner, Type[] typeArguments) {
            this.raw = raw;
            this.useOwner = useOwner;
            this.typeArguments = typeArguments;
        }

        @Override
        public Type getRawType() {
            return this.raw;
        }

        @Override
        public Type getOwnerType() {
            return this.useOwner;
        }

        @Override
        public Type[] getActualTypeArguments() {
            return (Type[])this.typeArguments.clone();
        }

        public String toString() {
            StringBuilder buf = new StringBuilder();
            buf.append(this.raw.getName());
            buf.append('<');
            buf.append(this.typeArguments[0].getTypeName());
            for (int i = 1; i < this.typeArguments.length; ++i) {
                buf.append(", ");
                buf.append(this.typeArguments[i].getTypeName());
            }
            buf.append('>');
            return buf.toString();
        }
    }
}

