/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.config.server.controller;

import com.alibaba.nacos.common.utils.CollectionUtils;
import com.alibaba.nacos.common.utils.StringUtils;
import com.alibaba.nacos.config.server.model.SampleResult;
import com.alibaba.nacos.config.server.remote.ConfigChangeListenContext;
import com.alibaba.nacos.config.server.service.LongPollingService;
import com.alibaba.nacos.config.server.service.dump.DumpService;
import com.alibaba.nacos.config.server.utils.GroupKey2;
import com.alibaba.nacos.core.remote.Connection;
import com.alibaba.nacos.core.remote.ConnectionManager;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1/cs/communication"})
public class CommunicationController {
    private final DumpService dumpService;
    private final LongPollingService longPollingService;
    private String trueStr = "true";
    @Autowired
    private ConfigChangeListenContext configChangeListenContext;
    @Autowired
    private ConnectionManager connectionManager;

    @Autowired
    public CommunicationController(DumpService dumpService, LongPollingService longPollingService) {
        this.dumpService = dumpService;
        this.longPollingService = longPollingService;
    }

    @GetMapping(value={"/dataChange"})
    public Boolean notifyConfigInfo(HttpServletRequest request, @RequestParam(value="dataId") String dataId, @RequestParam(value="group") String group, @RequestParam(value="tenant", required=false, defaultValue="") String tenant, @RequestParam(value="tag", required=false) String tag) {
        dataId = dataId.trim();
        group = group.trim();
        String lastModified = request.getHeader("lastModified");
        long lastModifiedTs = StringUtils.isEmpty((String)lastModified) ? -1L : Long.parseLong(lastModified);
        String handleIp = request.getHeader("opHandleIp");
        String isBetaStr = request.getHeader("isBeta");
        if (StringUtils.isNotBlank((String)isBetaStr) && this.trueStr.equals(isBetaStr)) {
            this.dumpService.dump(dataId, group, tenant, lastModifiedTs, handleIp, true);
        } else {
            this.dumpService.dump(dataId, group, tenant, tag, lastModifiedTs, handleIp);
        }
        return true;
    }

    @GetMapping(value={"/configWatchers"})
    public SampleResult getSubClientConfig(@RequestParam(value="dataId") String dataId, @RequestParam(value="group") String group, @RequestParam(value="tenant", required=false) String tenant, ModelMap modelMap) {
        group = StringUtils.isBlank((CharSequence)group) ? "DEFAULT_GROUP" : group;
        SampleResult result = this.longPollingService.getCollectSubscribleInfo(dataId, group, tenant);
        String groupKey = GroupKey2.getKey(dataId, group, tenant);
        Set<String> listenersClients = this.configChangeListenContext.getListeners(groupKey);
        if (CollectionUtils.isEmpty(listenersClients)) {
            return result;
        }
        HashMap<String, String> lisentersGroupkeyStatus = new HashMap<String, String>(listenersClients.size(), 1.0f);
        for (String connectionId : listenersClients) {
            String md5;
            Connection client = this.connectionManager.getConnection(connectionId);
            if (client == null || (md5 = this.configChangeListenContext.getListenKeyMd5(connectionId, groupKey)) == null) continue;
            lisentersGroupkeyStatus.put(client.getMetaInfo().getClientIp(), md5);
        }
        result.getLisentersGroupkeyStatus().putAll(lisentersGroupkeyStatus);
        return result;
    }

    @GetMapping(value={"/watcherConfigs"})
    public SampleResult getSubClientConfigByIp(HttpServletRequest request, HttpServletResponse response, @RequestParam(value="ip") String ip, ModelMap modelMap) {
        SampleResult result = this.longPollingService.getCollectSubscribleInfoByIp(ip);
        List connectionsByIp = this.connectionManager.getConnectionByIp(ip);
        for (Connection connectionByIp : connectionsByIp) {
            Map<String, String> listenKeys = this.configChangeListenContext.getListenKeys(connectionByIp.getMetaInfo().getConnectionId());
            if (listenKeys == null) continue;
            result.getLisentersGroupkeyStatus().putAll(listenKeys);
        }
        return result;
    }
}

