/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.config.server.controller;

import com.alibaba.nacos.auth.annotation.Secured;
import com.alibaba.nacos.auth.common.ActionTypes;
import com.alibaba.nacos.auth.exception.AccessException;
import com.alibaba.nacos.common.utils.NamespaceUtil;
import com.alibaba.nacos.config.server.auth.ConfigResourceParser;
import com.alibaba.nacos.config.server.model.ConfigHistoryInfo;
import com.alibaba.nacos.config.server.model.ConfigInfoWrapper;
import com.alibaba.nacos.config.server.model.Page;
import com.alibaba.nacos.config.server.service.repository.PersistService;
import com.alibaba.nacos.config.server.utils.ParamUtils;
import java.util.List;
import java.util.Objects;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1/cs/history"})
public class HistoryController {
    @Autowired
    protected PersistService persistService;

    @GetMapping(params={"search=accurate"})
    @Secured(action=ActionTypes.READ, parser=ConfigResourceParser.class)
    public Page<ConfigHistoryInfo> listConfigHistory(@RequestParam(value="dataId") String dataId, @RequestParam(value="group") String group, @RequestParam(value="tenant", required=false, defaultValue="") String tenant, @RequestParam(value="appName", required=false) String appName, @RequestParam(value="pageNo", required=false) Integer pageNo, @RequestParam(value="pageSize", required=false) Integer pageSize, ModelMap modelMap) {
        pageNo = null == pageNo ? 1 : pageNo;
        pageSize = null == pageSize ? 100 : pageSize;
        pageSize = Math.min(500, pageSize);
        return this.persistService.findConfigHistory(dataId, group, tenant, pageNo, pageSize);
    }

    @GetMapping
    @Secured(action=ActionTypes.READ, parser=ConfigResourceParser.class)
    public ConfigHistoryInfo getConfigHistoryInfo(@RequestParam(value="dataId") String dataId, @RequestParam(value="group") String group, @RequestParam(value="tenant", required=false, defaultValue="") String tenant, @RequestParam(value="nid") Long nid) throws AccessException {
        ConfigHistoryInfo configHistoryInfo = this.persistService.detailConfigHistory(nid);
        if (Objects.isNull(configHistoryInfo)) {
            return null;
        }
        this.checkHistoryInfoPermission(configHistoryInfo, dataId, group, tenant);
        return configHistoryInfo;
    }

    private void checkHistoryInfoPermission(ConfigHistoryInfo configHistoryInfo, String dataId, String group, String tenant) throws AccessException {
        if (Objects.equals(configHistoryInfo.getDataId(), dataId) && Objects.equals(configHistoryInfo.getGroup(), group)) {
            return;
        }
        throw new AccessException("Please check dataId and group.");
    }

    @GetMapping(value={"/previous"})
    @Secured(action=ActionTypes.READ, parser=ConfigResourceParser.class)
    public ConfigHistoryInfo getPreviousConfigHistoryInfo(@RequestParam(value="dataId") String dataId, @RequestParam(value="group") String group, @RequestParam(value="tenant", required=false, defaultValue="") String tenant, @RequestParam(value="id") Long id) throws AccessException {
        ConfigHistoryInfo configHistoryInfo = this.persistService.detailPreviousConfigHistory(id);
        if (Objects.isNull(configHistoryInfo)) {
            return null;
        }
        this.checkHistoryInfoPermission(configHistoryInfo, dataId, group, tenant);
        return configHistoryInfo;
    }

    @GetMapping(value={"/configs"})
    @Secured(action=ActionTypes.READ, parser=ConfigResourceParser.class)
    public List<ConfigInfoWrapper> getDataIds(@RequestParam(value="tenant") String tenant) {
        ParamUtils.checkTenant(tenant);
        tenant = NamespaceUtil.processNamespaceParameter((String)tenant);
        return this.persistService.queryConfigInfoByNamespace(tenant);
    }
}

