/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.config.server.utils;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZipUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(ZipUtils.class);

    public static byte[] zip(List<ZipItem> source) {
        byte[] result = null;
        try (ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
             ZipOutputStream zipOut = new ZipOutputStream(byteOut);){
            for (ZipItem item : source) {
                zipOut.putNextEntry(new ZipEntry(item.getItemName()));
                zipOut.write(item.getItemData().getBytes(StandardCharsets.UTF_8));
            }
            zipOut.flush();
            zipOut.finish();
            result = byteOut.toByteArray();
        }
        catch (IOException e) {
            LOGGER.error("an error occurred while compressing data.", (Throwable)e);
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static UnZipResult unzip(byte[] source) {
        ArrayList<ZipItem> itemList = new ArrayList<ZipItem>();
        ZipItem metaDataItem = null;
        try (ZipInputStream zipIn = new ZipInputStream(new ByteArrayInputStream(source));){
            ZipEntry entry;
            while ((entry = zipIn.getNextEntry()) != null) {
                if (entry.isDirectory()) continue;
                try {
                    ByteArrayOutputStream out = new ByteArrayOutputStream();
                    Throwable throwable = null;
                    try {
                        int offset;
                        byte[] buffer = new byte[1024];
                        while ((offset = zipIn.read(buffer)) != -1) {
                            out.write(buffer, 0, offset);
                        }
                        String entryName = entry.getName();
                        if (metaDataItem == null && ".meta.yml".equals(entryName)) {
                            metaDataItem = new ZipItem(entryName, out.toString("UTF-8"));
                            continue;
                        }
                        if (metaDataItem == null && ".metadata.yml".equals(entryName)) {
                            metaDataItem = new ZipItem(entryName, out.toString("UTF-8"));
                            continue;
                        }
                        itemList.add(new ZipItem(entryName, out.toString("UTF-8")));
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (out == null) continue;
                        if (throwable != null) {
                            try {
                                out.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        out.close();
                    }
                }
                catch (IOException e) {
                    LOGGER.error("unzip error", (Throwable)e);
                }
            }
            return new UnZipResult(itemList, metaDataItem);
        }
        catch (IOException e) {
            LOGGER.error("unzip error", (Throwable)e);
        }
        return new UnZipResult(itemList, metaDataItem);
    }

    public static class UnZipResult {
        private List<ZipItem> zipItemList;
        private ZipItem metaDataItem;

        public UnZipResult(List<ZipItem> zipItemList, ZipItem metaDataItem) {
            this.zipItemList = zipItemList;
            this.metaDataItem = metaDataItem;
        }

        public List<ZipItem> getZipItemList() {
            return this.zipItemList;
        }

        public void setZipItemList(List<ZipItem> zipItemList) {
            this.zipItemList = zipItemList;
        }

        public ZipItem getMetaDataItem() {
            return this.metaDataItem;
        }

        public void setMetaDataItem(ZipItem metaDataItem) {
            this.metaDataItem = metaDataItem;
        }
    }

    public static class ZipItem {
        private String itemName;
        private String itemData;

        public ZipItem(String itemName, String itemData) {
            this.itemName = itemName;
            this.itemData = itemData;
        }

        public String getItemName() {
            return this.itemName;
        }

        public void setItemName(String itemName) {
            this.itemName = itemName;
        }

        public String getItemData() {
            return this.itemData;
        }

        public void setItemData(String itemData) {
            this.itemData = itemData;
        }
    }
}

