/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.core.auth;

import com.alibaba.nacos.auth.AuthManager;
import com.alibaba.nacos.auth.annotation.Secured;
import com.alibaba.nacos.auth.common.AuthConfigs;
import com.alibaba.nacos.auth.exception.AccessException;
import com.alibaba.nacos.auth.model.Permission;
import com.alibaba.nacos.auth.parser.ResourceParser;
import com.alibaba.nacos.common.utils.ExceptionUtil;
import com.alibaba.nacos.common.utils.StringUtils;
import com.alibaba.nacos.core.code.ControllerMethodsCache;
import com.alibaba.nacos.core.utils.Loggers;
import com.alibaba.nacos.core.utils.WebUtils;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;

public class AuthFilter
implements Filter {
    @Autowired
    private AuthConfigs authConfigs;
    @Autowired
    private AuthManager authManager;
    @Autowired
    private ControllerMethodsCache methodsCache;
    private Map<Class<? extends ResourceParser>, ResourceParser> parserInstance = new ConcurrentHashMap<Class<? extends ResourceParser>, ResourceParser>();

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (!this.authConfigs.isAuthEnabled()) {
            chain.doFilter(request, response);
            return;
        }
        HttpServletRequest req = (HttpServletRequest)request;
        HttpServletResponse resp = (HttpServletResponse)response;
        if (this.authConfigs.isEnableUserAgentAuthWhite()) {
            String userAgent = WebUtils.getUserAgent(req);
            if (StringUtils.startsWith((CharSequence)userAgent, (CharSequence)"Nacos-Server")) {
                chain.doFilter(request, response);
                return;
            }
        } else if (StringUtils.isNotBlank((String)this.authConfigs.getServerIdentityKey()) && StringUtils.isNotBlank((String)this.authConfigs.getServerIdentityValue())) {
            String serverIdentity = req.getHeader(this.authConfigs.getServerIdentityKey());
            if (StringUtils.isNotBlank((String)serverIdentity)) {
                if (this.authConfigs.getServerIdentityValue().equals(serverIdentity)) {
                    chain.doFilter(request, response);
                    return;
                }
                Loggers.AUTH.warn("Invalid server identity value for {} from {}", (Object)this.authConfigs.getServerIdentityKey(), (Object)req.getRemoteHost());
            }
        } else {
            resp.sendError(403, "Invalid server identity key or value, Please make sure set `nacos.core.auth.server.identity.key` and `nacos.core.auth.server.identity.value`, or open `nacos.core.auth.enable.userAgentAuthWhite`");
            return;
        }
        try {
            Method method = this.methodsCache.getMethod(req);
            if (method == null) {
                chain.doFilter(request, response);
                return;
            }
            if (method.isAnnotationPresent(Secured.class) && this.authConfigs.isAuthEnabled()) {
                if (Loggers.AUTH.isDebugEnabled()) {
                    Loggers.AUTH.debug("auth start, request: {} {}", (Object)req.getMethod(), (Object)req.getRequestURI());
                }
                Secured secured = method.getAnnotation(Secured.class);
                String action = secured.action().toString();
                String resource = secured.resource();
                if (StringUtils.isBlank((CharSequence)resource)) {
                    ResourceParser parser = this.getResourceParser(secured.parser());
                    resource = parser.parseName((Object)req);
                }
                if (StringUtils.isBlank((CharSequence)resource)) {
                    throw new AccessException("resource name invalid!");
                }
                this.authManager.auth(new Permission(resource, action), this.authManager.login((Object)req));
            }
            chain.doFilter(request, response);
        }
        catch (AccessException e) {
            if (Loggers.AUTH.isDebugEnabled()) {
                Loggers.AUTH.debug("access denied, request: {} {}, reason: {}", new Object[]{req.getMethod(), req.getRequestURI(), e.getErrMsg()});
            }
            resp.sendError(403, e.getErrMsg());
        }
        catch (IllegalArgumentException e) {
            resp.sendError(400, ExceptionUtil.getAllExceptionMsg((Throwable)e));
        }
        catch (Exception e) {
            resp.sendError(500, "Server failed," + e.getMessage());
        }
    }

    private ResourceParser getResourceParser(Class<? extends ResourceParser> parseClass) throws IllegalAccessException, InstantiationException {
        ResourceParser parser = this.parserInstance.get(parseClass);
        if (parser == null) {
            parser = parseClass.newInstance();
            this.parserInstance.put(parseClass, parser);
        }
        return parser;
    }
}

