/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.core.cluster;

import com.alibaba.nacos.common.utils.ExceptionUtil;
import com.alibaba.nacos.core.utils.Loggers;

public abstract class Task
implements Runnable {
    protected volatile boolean shutdown = false;

    @Override
    public void run() {
        if (this.shutdown) {
            return;
        }
        try {
            this.executeBody();
        }
        catch (Throwable t) {
            Loggers.CORE.error("this task execute has error : {}", (Object)ExceptionUtil.getStackTrace((Throwable)t));
        }
        finally {
            if (!this.shutdown) {
                this.after();
            }
        }
    }

    protected abstract void executeBody();

    protected void after() {
    }

    public void shutdown() {
        this.shutdown = true;
    }
}

