/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.core.distributed.raft;

import com.alibaba.nacos.common.utils.JacksonUtils;
import com.alibaba.nacos.consistency.Config;
import com.alibaba.nacos.consistency.cp.RequestProcessor4CP;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;

@Component
@ConfigurationProperties(prefix="nacos.core.protocol.raft")
public class RaftConfig
implements Config<RequestProcessor4CP> {
    private static final long serialVersionUID = 9174789390266064002L;
    private Map<String, String> data = Collections.synchronizedMap(new HashMap());
    private String selfAddress;
    private Set<String> members = Collections.synchronizedSet(new HashSet());

    public void setMembers(String self, Set<String> members) {
        this.selfAddress = self;
        this.members.clear();
        this.members.addAll(members);
    }

    public String getSelfMember() {
        return this.selfAddress;
    }

    public Set<String> getMembers() {
        return this.members;
    }

    public void addMembers(Set<String> members) {
        this.members.addAll(members);
    }

    public void removeMembers(Set<String> members) {
        this.members.removeAll(members);
    }

    public Map<String, String> getData() {
        return this.data;
    }

    public void setData(Map<String, String> data) {
        this.data = Collections.synchronizedMap(data);
    }

    public void setVal(String key, String value) {
        this.data.put(key, value);
    }

    public String getVal(String key) {
        return this.data.get(key);
    }

    public String getValOfDefault(String key, String defaultVal) {
        return this.data.getOrDefault(key, defaultVal);
    }

    public String toString() {
        try {
            return JacksonUtils.toJson(this.data);
        }
        catch (Exception e) {
            return String.valueOf(this.data);
        }
    }
}

