/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.core.listener;

import com.alibaba.nacos.core.listener.NacosApplicationListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.env.ConfigurableEnvironment;

public class LoggingApplicationListener
implements NacosApplicationListener {
    private static final String DEFAULT_NACOS_LOGBACK_LOCATION = "classpath:META-INF/logback/nacos.xml";
    private static final Logger LOGGER = LoggerFactory.getLogger(LoggingApplicationListener.class);

    @Override
    public void starting() {
    }

    @Override
    public void environmentPrepared(ConfigurableEnvironment environment) {
        if (!environment.containsProperty("logging.config")) {
            System.setProperty("logging.config", DEFAULT_NACOS_LOGBACK_LOCATION);
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("There is no property named \"{}\" in Spring Boot Environment, and whose value is {} will be set into System's Properties", (Object)"logging.config", (Object)DEFAULT_NACOS_LOGBACK_LOCATION);
            }
        }
    }

    @Override
    public void contextPrepared(ConfigurableApplicationContext context) {
    }

    @Override
    public void contextLoaded(ConfigurableApplicationContext context) {
    }

    @Override
    public void started(ConfigurableApplicationContext context) {
    }

    @Override
    public void running(ConfigurableApplicationContext context) {
    }

    @Override
    public void failed(ConfigurableApplicationContext context, Throwable exception) {
    }
}

